/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.metrics;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.oxia.client.metrics.Counter;
import io.oxia.client.metrics.LatencyHistogram;
import io.oxia.client.metrics.Unit;
import io.oxia.client.metrics.UpDownCounter;

public class InstrumentProvider {
    public static final InstrumentProvider NOOP = new InstrumentProvider(OpenTelemetry.noop(), "default");
    private final String namespace;
    private final Meter meter;

    public InstrumentProvider(OpenTelemetry otel, String namespace) {
        this.namespace = namespace;
        if (otel == null) {
            otel = GlobalOpenTelemetry.get();
        }
        this.meter = otel.getMeterProvider().meterBuilder("io.oxia.client").build();
    }

    public Counter newCounter(String name, Unit unit, String description, Attributes attributes) {
        return new Counter(this.meter, name, unit, description, this.namespace, attributes);
    }

    public UpDownCounter newUpDownCounter(String name, Unit unit, String description, Attributes attributes) {
        return new UpDownCounter(this.meter, name, unit, description, this.namespace, attributes);
    }

    public LatencyHistogram newLatencyHistogram(String name, String description, Attributes attributes) {
        return new LatencyHistogram(this.meter, name, description, this.namespace, attributes);
    }
}

