/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import io.opentelemetry.api.metrics.ObservableLongCounter;
import io.prometheus.client.Counter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.DimensionStats;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.opentelemetry.OpenTelemetryAttributes;

public class BrokerOperabilityMetrics
implements AutoCloseable {
    private static final Counter TOPIC_LOAD_FAILED = (Counter)Counter.build((String)"topic_load_failed", (String)"-").register();
    private final List<Metrics> metricsList = new ArrayList<Metrics>();
    private final String localCluster;
    private final DimensionStats topicLoadStats;
    private final String brokerName;
    private final LongAdder connectionTotalCreatedCount;
    private final LongAdder connectionTotalClosedCount;
    private final LongAdder connectionActive;
    private volatile int healthCheckStatus;
    private final LongAdder connectionCreateSuccessCount;
    private final LongAdder connectionCreateFailCount;
    public static final String CONNECTION_COUNTER_METRIC_NAME = "pulsar.broker.connection.count";
    private final ObservableLongCounter connectionCounter;
    public static final String CONNECTION_CREATE_COUNTER_METRIC_NAME = "pulsar.broker.connection.create.operation.count";
    private final ObservableLongCounter connectionCreateCounter;

    public BrokerOperabilityMetrics(PulsarService pulsar) {
        this.localCluster = pulsar.getConfiguration().getClusterName();
        this.topicLoadStats = new DimensionStats("pulsar_topic_load_times", 60L);
        this.brokerName = pulsar.getAdvertisedAddress();
        this.connectionTotalCreatedCount = new LongAdder();
        this.connectionTotalClosedCount = new LongAdder();
        this.connectionActive = new LongAdder();
        this.healthCheckStatus = -1;
        this.connectionCreateSuccessCount = new LongAdder();
        this.connectionCreateFailCount = new LongAdder();
        this.connectionCounter = pulsar.getOpenTelemetry().getMeter().counterBuilder(CONNECTION_COUNTER_METRIC_NAME).setDescription("The number of connections.").setUnit("{connection}").buildWithCallback(measurement -> {
            long closedConnections = this.connectionTotalClosedCount.sum();
            long openedConnections = this.connectionTotalCreatedCount.sum();
            long activeConnections = openedConnections - closedConnections;
            measurement.record(activeConnections, OpenTelemetryAttributes.ConnectionStatus.ACTIVE.attributes);
            measurement.record(openedConnections, OpenTelemetryAttributes.ConnectionStatus.OPEN.attributes);
            measurement.record(closedConnections, OpenTelemetryAttributes.ConnectionStatus.CLOSE.attributes);
        });
        this.connectionCreateCounter = pulsar.getOpenTelemetry().getMeter().counterBuilder(CONNECTION_CREATE_COUNTER_METRIC_NAME).setDescription("The number of connection create operations.").setUnit("{operation}").buildWithCallback(measurement -> {
            measurement.record(this.connectionCreateSuccessCount.sum(), OpenTelemetryAttributes.ConnectionCreateStatus.SUCCESS.attributes);
            measurement.record(this.connectionCreateFailCount.sum(), OpenTelemetryAttributes.ConnectionCreateStatus.FAILURE.attributes);
        });
    }

    @Override
    public void close() throws Exception {
        this.connectionCounter.close();
        this.connectionCreateCounter.close();
    }

    public List<Metrics> getMetrics() {
        this.generate();
        return this.metricsList;
    }

    private void generate() {
        this.reset();
        this.metricsList.add(this.getTopicLoadMetrics());
        this.metricsList.add(this.getConnectionMetrics());
        this.metricsList.add(this.getHealthMetrics());
    }

    public Metrics generateConnectionMetrics() {
        return this.getConnectionMetrics();
    }

    Metrics getConnectionMetrics() {
        Metrics rMetrics = Metrics.create(this.getDimensionMap("broker_connection"));
        rMetrics.put("brk_connection_created_total_count", (Object)this.connectionTotalCreatedCount.longValue());
        rMetrics.put("brk_connection_create_success_count", (Object)this.connectionCreateSuccessCount.longValue());
        rMetrics.put("brk_connection_create_fail_count", (Object)this.connectionCreateFailCount.longValue());
        rMetrics.put("brk_connection_closed_total_count", (Object)this.connectionTotalClosedCount.longValue());
        rMetrics.put("brk_active_connections", (Object)this.connectionActive.longValue());
        return rMetrics;
    }

    Metrics getHealthMetrics() {
        Metrics rMetrics = Metrics.create(this.getDimensionMap("broker_health"));
        rMetrics.put("brk_health", (Object)this.healthCheckStatus);
        return rMetrics;
    }

    Map<String, String> getDimensionMap(String metricsName) {
        HashMap<String, String> dimensionMap = new HashMap<String, String>();
        dimensionMap.put("broker", this.brokerName);
        dimensionMap.put("cluster", this.localCluster);
        dimensionMap.put("metric", metricsName);
        return dimensionMap;
    }

    Metrics getTopicLoadMetrics() {
        Metrics metrics = this.getDimensionMetrics("pulsar_topic_load_times", "topic_load", this.topicLoadStats);
        metrics.put("brk_topic_load_failed_count", (Object)TOPIC_LOAD_FAILED.get());
        return metrics;
    }

    Metrics getDimensionMetrics(String metricsName, String dimensionName, DimensionStats stats) {
        Metrics dMetrics = Metrics.create(this.getDimensionMap(metricsName));
        DimensionStats.DimensionStatsSnapshot statsSnapshot = stats.getSnapshot();
        dMetrics.put("brk_" + dimensionName + "_time_mean_ms", (Object)statsSnapshot.getMeanDimension());
        dMetrics.put("brk_" + dimensionName + "_time_median_ms", (Object)statsSnapshot.getMedianDimension());
        dMetrics.put("brk_" + dimensionName + "_time_75percentile_ms", (Object)statsSnapshot.getDimension75());
        dMetrics.put("brk_" + dimensionName + "_time_95percentile_ms", (Object)statsSnapshot.getDimension95());
        dMetrics.put("brk_" + dimensionName + "_time_99_percentile_ms", (Object)statsSnapshot.getDimension99());
        dMetrics.put("brk_" + dimensionName + "_time_99_9_percentile_ms", (Object)statsSnapshot.getDimension999());
        dMetrics.put("brk_" + dimensionName + "_time_99_99_percentile_ms", (Object)statsSnapshot.getDimension9999());
        dMetrics.put("brk_" + dimensionName + "_rate_s", (Object)statsSnapshot.getDimensionCount());
        return dMetrics;
    }

    public void reset() {
        this.metricsList.clear();
        this.topicLoadStats.reset();
    }

    public void recordTopicLoadTimeValue(long topicLoadLatencyMs) {
        this.topicLoadStats.recordDimensionTimeValue(topicLoadLatencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordTopicLoadFailed() {
        TOPIC_LOAD_FAILED.inc();
    }

    public void recordConnectionCreate() {
        this.connectionTotalCreatedCount.increment();
        this.connectionActive.increment();
    }

    public void recordConnectionClose() {
        this.connectionTotalClosedCount.increment();
        this.connectionActive.decrement();
    }

    public void recordConnectionCreateSuccess() {
        this.connectionCreateSuccessCount.increment();
    }

    public void recordConnectionCreateFail() {
        this.connectionCreateFailCount.increment();
    }

    public void recordHealthCheckStatusSuccess() {
        this.healthCheckStatus = 1;
    }

    public void recordHealthCheckStatusFail() {
        this.healthCheckStatus = 0;
    }
}

