/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.session;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.api.common.Attributes;
import io.oxia.client.ClientConfig;
import io.oxia.client.grpc.OxiaStub;
import io.oxia.client.grpc.OxiaStubProvider;
import io.oxia.client.metrics.Counter;
import io.oxia.client.metrics.InstrumentProvider;
import io.oxia.client.metrics.Unit;
import io.oxia.client.session.SessionNotificationListener;
import io.oxia.proto.CloseSessionRequest;
import io.oxia.proto.CloseSessionResponse;
import io.oxia.proto.KeepAliveResponse;
import io.oxia.proto.SessionHeartbeat;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
implements StreamObserver<KeepAliveResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    @NonNull
    private final OxiaStubProvider stubProvider;
    @NonNull
    private final Duration sessionTimeout;
    @NonNull
    private final Duration heartbeatInterval;
    @VisibleForTesting
    private final long shardId;
    private final long sessionId;
    private final String clientIdentifier;
    @NonNull
    private final SessionHeartbeat heartbeat;
    @NonNull
    private final SessionNotificationListener listener;
    private volatile boolean closed;
    private Counter sessionsOpened;
    private Counter sessionsExpired;
    private Counter sessionsClosed;
    private final ScheduledFuture<?> heartbeatFuture;
    private volatile Instant lastSuccessfullResponse;

    Session(@NonNull ScheduledExecutorService executor, @NonNull OxiaStubProvider stubProvider, @NonNull ClientConfig config, long shardId, long sessionId, InstrumentProvider instrumentProvider, SessionNotificationListener listener) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.stubProvider = stubProvider;
        this.sessionTimeout = config.sessionTimeout();
        this.heartbeatInterval = Duration.ofMillis(Math.max(config.sessionTimeout().toMillis() / 10L, Duration.ofSeconds(2L).toMillis()));
        this.shardId = shardId;
        this.sessionId = sessionId;
        this.clientIdentifier = config.clientIdentifier();
        this.heartbeat = SessionHeartbeat.newBuilder().setShard(shardId).setSessionId(sessionId).build();
        this.listener = listener;
        log.info("Session created shard={} sessionId={} clientIdentity={}", new Object[]{shardId, sessionId, config.clientIdentifier()});
        this.sessionsOpened = instrumentProvider.newCounter("oxia.client.sessions.opened", Unit.Sessions, "The total number of sessions opened by this client", Attributes.builder().put("oxia.shard", shardId).build());
        this.sessionsExpired = instrumentProvider.newCounter("oxia.client.sessions.expired", Unit.Sessions, "The total number of sessions expired int this client", Attributes.builder().put("oxia.shard", shardId).build());
        this.sessionsClosed = instrumentProvider.newCounter("oxia.client.sessions.closed", Unit.Sessions, "The total number of sessions closed by this client", Attributes.builder().put("oxia.shard", shardId).build());
        this.sessionsOpened.increment();
        this.lastSuccessfullResponse = Instant.now();
        this.heartbeatFuture = executor.scheduleAtFixedRate(() -> {
            try {
                this.sendKeepAlive();
            }
            catch (Throwable ex) {
                log.warn("receive error when send keep-alive request", Throwables.getRootCause((Throwable)ex));
            }
        }, this.heartbeatInterval.toMillis(), this.heartbeatInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void sendKeepAlive() {
        Duration diff = Duration.between(this.lastSuccessfullResponse, Instant.now());
        if (diff.toMillis() > this.sessionTimeout.toMillis()) {
            this.handleSessionExpired();
            return;
        }
        this.stubProvider.getStubForShard(this.shardId).async().keepAlive(this.heartbeat, this);
    }

    public void onNext(KeepAliveResponse value) {
        this.lastSuccessfullResponse = Instant.now();
        if (log.isDebugEnabled()) {
            log.debug("Received keep-alive response shard={} sessionId={} clientIdentity={}", new Object[]{this.shardId, this.sessionId, this.clientIdentifier});
        }
    }

    public void onError(Throwable t) {
        log.warn("Error during session keep-alive shard={} sessionId={} clientIdentity={}: {}", new Object[]{this.shardId, this.sessionId, this.clientIdentifier, t.getMessage()});
    }

    public void onCompleted() {
    }

    private void handleSessionExpired() {
        this.sessionsExpired.increment();
        log.warn("Session expired shard={} sessionId={} clientIdentity={}", new Object[]{this.shardId, this.sessionId, this.clientIdentifier});
        this.close();
    }

    public CompletableFuture<Void> close() {
        this.sessionsClosed.increment();
        this.heartbeatFuture.cancel(true);
        OxiaStub stub = this.stubProvider.getStubForShard(this.shardId);
        CloseSessionRequest request = CloseSessionRequest.newBuilder().setShard(this.shardId).setSessionId(this.sessionId).build();
        final CompletableFuture result = new CompletableFuture();
        stub.async().closeSession(request, new StreamObserver<CloseSessionResponse>(){

            public void onNext(CloseSessionResponse value) {
            }

            public void onError(Throwable t) {
                Session.this.listener.onSessionClosed(Session.this);
                result.complete(null);
            }

            public void onCompleted() {
                Session.this.listener.onSessionClosed(Session.this);
                result.complete(null);
            }
        });
        return result.whenComplete((__, ignore) -> log.info("Session closed shard={} sessionId={} clientIdentity={}", new Object[]{this.shardId, this.sessionId, this.clientIdentifier}));
    }

    @Generated
    long getShardId() {
        return this.shardId;
    }

    @Generated
    public long getSessionId() {
        return this.sessionId;
    }
}

