/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.common.naming.BundleSplitOption;
import org.apache.pulsar.common.naming.FlowOrQpsEquallyDivideBundleSplitOption;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleSplitAlgorithm;
import org.apache.pulsar.common.policies.data.stats.TopicStatsImpl;

public class FlowOrQpsEquallyDivideBundleSplitAlgorithm
implements NamespaceBundleSplitAlgorithm {
    private static final long MBytes = 0x100000L;

    @Override
    public CompletableFuture<List<Long>> getSplitBoundary(BundleSplitOption bundleSplitOptionTmp) {
        FlowOrQpsEquallyDivideBundleSplitOption bundleSplitOption = (FlowOrQpsEquallyDivideBundleSplitOption)bundleSplitOptionTmp;
        NamespaceService service = bundleSplitOption.getService();
        NamespaceBundle bundle = bundleSplitOption.getBundle();
        Map<String, TopicStatsImpl> topicStatsMap = bundleSplitOption.getTopicStatsMap();
        int loadBalancerNamespaceBundleMaxMsgRate = bundleSplitOption.getLoadBalancerNamespaceBundleMaxMsgRate();
        double diffThreshold = (double)bundleSplitOption.getFlowOrQpsDifferenceThresholdPercentage() / 100.0;
        long loadBalancerNamespaceBundleMaxBandwidthBytes = (long)bundleSplitOption.getLoadBalancerNamespaceBundleMaxBandwidthMbytes() * 0x100000L;
        return service.getOwnedTopicListForNamespaceBundle(bundle).thenCompose(topics -> {
            if (topics == null || topics.size() <= 1) {
                return CompletableFuture.completedFuture(null);
            }
            double bundleThroughput = 0.0;
            double bundleMsgRate = 0.0;
            HashMap<Long, TopicInfo> topicInfoMap = new HashMap<Long, TopicInfo>();
            ArrayList<Long> topicHashList = new ArrayList<Long>(topics.size());
            for (String topic : topics) {
                TopicStatsImpl topicStats = (TopicStatsImpl)topicStatsMap.get(topic);
                if (topicStats == null) continue;
                double msgRateIn = topicStats.getMsgRateIn();
                double msgRateOut = topicStats.getMsgRateOut();
                double msgThroughputIn = topicStats.getMsgThroughputIn();
                double msgThroughputOut = topicStats.getMsgThroughputOut();
                double msgRate = msgRateIn + msgRateOut;
                double throughput = msgThroughputIn + msgThroughputOut;
                if (msgRate <= 0.0 && throughput <= 0.0) continue;
                Long hashCode = bundle.getNamespaceBundleFactory().getLongHashCode(topic);
                topicHashList.add(hashCode);
                topicInfoMap.put(hashCode, new TopicInfo(topic, msgRate, throughput));
                bundleThroughput += throughput;
                bundleMsgRate += msgRate;
            }
            if (topicInfoMap.size() < 2 || bundleMsgRate < (double)loadBalancerNamespaceBundleMaxMsgRate * (1.0 + diffThreshold) && bundleThroughput < (double)loadBalancerNamespaceBundleMaxBandwidthBytes * (1.0 + diffThreshold)) {
                return CompletableFuture.completedFuture(null);
            }
            Collections.sort(topicHashList);
            ArrayList<Long> splitResults = new ArrayList<Long>();
            double bundleMsgRateTmp = ((TopicInfo)topicInfoMap.get(topicHashList.get((int)0))).msgRate;
            double bundleThroughputTmp = ((TopicInfo)topicInfoMap.get(topicHashList.get((int)0))).throughput;
            for (int i = 1; i < topicHashList.size(); ++i) {
                long topicHashCode = (Long)topicHashList.get(i);
                double msgRate = ((TopicInfo)topicInfoMap.get((Object)Long.valueOf((long)topicHashCode))).msgRate;
                double throughput = ((TopicInfo)topicInfoMap.get((Object)Long.valueOf((long)topicHashCode))).throughput;
                if (bundleMsgRateTmp + msgRate > (double)loadBalancerNamespaceBundleMaxMsgRate || bundleThroughputTmp + throughput > (double)loadBalancerNamespaceBundleMaxBandwidthBytes) {
                    long splitStart = (Long)topicHashList.get(i - 1);
                    long splitEnd = (Long)topicHashList.get(i);
                    long splitMiddle = splitStart + (splitEnd - splitStart) / 2L + 1L;
                    splitResults.add(splitMiddle);
                    bundleMsgRateTmp = msgRate;
                    bundleThroughputTmp = throughput;
                    continue;
                }
                bundleMsgRateTmp += msgRate;
                bundleThroughputTmp += throughput;
            }
            return CompletableFuture.completedFuture(splitResults);
        });
    }

    class TopicInfo {
        String topicName;
        double msgRate;
        double throughput;

        public TopicInfo(String topicName, double msgRate, double throughput) {
            this.topicName = topicName;
            this.msgRate = msgRate;
            this.throughput = throughput;
        }
    }
}

