/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.plain;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.UsernamePasswordAuthenticationProvider;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;

public class PlainNegotiator
implements SaslNegotiator {
    public static final String MECHANISM = "PLAIN";
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final UsernamePasswordAuthenticationProvider _usernamePasswordAuthenticationProvider;
    private volatile State _state = State.INITIAL;
    private volatile String _username;

    public PlainNegotiator(UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider) {
        this._usernamePasswordAuthenticationProvider = usernamePasswordAuthenticationProvider;
    }

    @Override
    public AuthenticationResult handleResponse(byte[] response) {
        if (this._state == State.COMPLETE) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, new IllegalStateException("Multiple Authentications not permitted."));
        }
        if (this._state == State.INITIAL && (response == null || response.length == 0)) {
            this._state = State.CHALLENGE_SENT;
            return new AuthenticationResult(new byte[0], AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        this._state = State.COMPLETE;
        if (response == null || response.length == 0) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, new IllegalArgumentException("Invalid PLAIN encoding, authzid null terminator not found"));
        }
        int authzidNullPosition = this.findNullPosition(response, 0);
        if (authzidNullPosition < 0) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, new IllegalArgumentException("Invalid PLAIN encoding, authzid null terminator not found"));
        }
        int authcidNullPosition = this.findNullPosition(response, authzidNullPosition + 1);
        if (authcidNullPosition < 0) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, new IllegalArgumentException("Invalid PLAIN encoding, authcid null terminator not found"));
        }
        this._username = new String(response, authzidNullPosition + 1, authcidNullPosition - authzidNullPosition - 1, UTF8);
        int passwordLen = response.length - authcidNullPosition - 1;
        String password = new String(response, authcidNullPosition + 1, passwordLen, UTF8);
        return this._usernamePasswordAuthenticationProvider.authenticate(this._username, password);
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getAttemptedAuthenticationId() {
        return this._username;
    }

    private int findNullPosition(byte[] response, int startPosition) {
        for (int position = startPosition; position < response.length; ++position) {
            if (response[position] != 0) continue;
            return position;
        }
        return -1;
    }

    static enum State {
        INITIAL,
        CHALLENGE_SENT,
        COMPLETE;

    }
}

