/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.group.cloudfoundry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2UserPrincipal;
import org.apache.qpid.server.security.group.GroupPrincipal;
import org.apache.qpid.server.security.group.cloudfoundry.CloudFoundryDashboardManagementGroupProvider;
import org.apache.qpid.server.util.ConnectionBuilder;
import org.apache.qpid.server.util.ExternalServiceException;
import org.apache.qpid.server.util.ExternalServiceTimeoutException;
import org.apache.qpid.server.util.ParameterizedTypes;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudFoundryDashboardManagementGroupProviderImpl
extends AbstractConfiguredObject<CloudFoundryDashboardManagementGroupProviderImpl>
implements CloudFoundryDashboardManagementGroupProvider<CloudFoundryDashboardManagementGroupProviderImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudFoundryDashboardManagementGroupProviderImpl.class);
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    private final ObjectMapper _objectMapper = new ObjectMapper();
    @ManagedAttributeField
    private URI _cloudFoundryEndpointURI;
    @ManagedAttributeField
    private TrustStore _trustStore;
    @ManagedAttributeField
    private Map<String, String> _serviceToManagementGroupMapping;
    private List<String> _tlsProtocolAllowList;
    private List<String> _tlsProtocolDenyList;
    private List<String> _tlsCipherSuiteAllowList;
    private List<String> _tlsCipherSuiteDenyList;
    private int _connectTimeout;
    private int _readTimeout;

    @ManagedObjectFactoryConstructor
    public CloudFoundryDashboardManagementGroupProviderImpl(Map<String, Object> attributes, Container<?> container) {
        super(container, attributes);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this._tlsProtocolAllowList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.protocolAllowList");
        this._tlsProtocolDenyList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.protocolDenyList");
        this._tlsCipherSuiteAllowList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.cipherSuiteAllowList");
        this._tlsCipherSuiteDenyList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.cipherSuiteDenyList");
        this._connectTimeout = this.getContextValue(Integer.class, "qpid.groupprovider.cloudfoundry.connectTimeout");
        this._readTimeout = this.getContextValue(Integer.class, "qpid.groupprovider.cloudfoundry.readTimeout");
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        CloudFoundryDashboardManagementGroupProvider validationProxy = (CloudFoundryDashboardManagementGroupProvider)proxyForValidation;
        this.validateSecureEndpoint(validationProxy);
        this.validateMapping(validationProxy);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this.validateSecureEndpoint(this);
        this.validateMapping(this);
    }

    private void validateSecureEndpoint(CloudFoundryDashboardManagementGroupProvider<?> provider) {
        if (!"https".equals(provider.getCloudFoundryEndpointURI().getScheme())) {
            throw new IllegalConfigurationException(String.format("CloudFoundryDashboardManagementEndpoint is not secure: '%s'", provider.getCloudFoundryEndpointURI()));
        }
    }

    private void validateMapping(CloudFoundryDashboardManagementGroupProvider<?> provider) {
        for (Map.Entry<String, String> entry : provider.getServiceToManagementGroupMapping().entrySet()) {
            if ("".equals(entry.getKey())) {
                throw new IllegalConfigurationException("Service instance id may not be empty");
            }
            if (!"".equals(entry.getValue())) continue;
            throw new IllegalConfigurationException("Group name for service id '" + entry.getKey() + "' may not be empty");
        }
    }

    @Override
    public Set<Principal> getGroupPrincipalsForUser(Principal userPrincipal) {
        if (!(userPrincipal instanceof OAuth2UserPrincipal)) {
            return Collections.emptySet();
        }
        if (this._serviceToManagementGroupMapping == null) {
            throw new IllegalConfigurationException("CloudFoundryDashboardManagementGroupProvider serviceToManagementGroupMapping may not be null");
        }
        OAuth2UserPrincipal oauth2UserPrincipal = (OAuth2UserPrincipal)userPrincipal;
        String accessToken = oauth2UserPrincipal.getAccessToken();
        HashSet<Principal> groupPrincipals = new HashSet<Principal>();
        for (Map.Entry<String, String> entry : this._serviceToManagementGroupMapping.entrySet()) {
            String serviceInstanceId = entry.getKey();
            String managementGroupName = entry.getValue();
            if (this.mayManageServiceInstance(serviceInstanceId, accessToken)) {
                LOGGER.debug("Adding group '{}' to the set of Principals", (Object)managementGroupName);
                groupPrincipals.add(new GroupPrincipal(managementGroupName, this));
                continue;
            }
            LOGGER.debug("CloudFoundryDashboardManagementEndpoint denied management permission for service instance '{}'", (Object)serviceInstanceId);
        }
        return groupPrincipals;
    }

    private boolean mayManageServiceInstance(String serviceInstanceId, String accessToken) {
        boolean bl;
        block17: {
            HttpURLConnection connection;
            String cloudFoundryEndpoint = String.format("%s/v2/service_instances/%s/permissions", this.getCloudFoundryEndpointURI().toString(), serviceInstanceId);
            try {
                ConnectionBuilder connectionBuilder = new ConnectionBuilder(new URL(cloudFoundryEndpoint));
                connectionBuilder.setConnectTimeout(this._connectTimeout).setReadTimeout(this._readTimeout);
                if (this._trustStore != null) {
                    try {
                        connectionBuilder.setTrustMangers(this._trustStore.getTrustManagers());
                    }
                    catch (GeneralSecurityException e) {
                        throw new ServerScopedRuntimeException("Cannot initialise TLS", e);
                    }
                }
                connectionBuilder.setTlsProtocolAllowList(this._tlsProtocolAllowList).setTlsProtocolDenyList(this._tlsProtocolDenyList).setTlsCipherSuiteAllowList(this._tlsCipherSuiteAllowList).setTlsCipherSuiteDenyList(this._tlsCipherSuiteDenyList);
                LOGGER.debug("About to call CloudFoundryDashboardManagementEndpoint '{}'", (Object)cloudFoundryEndpoint);
                connection = connectionBuilder.build();
                connection.setRequestProperty("Accept-Charset", UTF8);
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("Authorization", "Bearer " + accessToken);
                connection.connect();
            }
            catch (SocketTimeoutException e) {
                throw new ExternalServiceTimeoutException(String.format("Timed out trying to connect to CloudFoundryDashboardManagementEndpoint '%s'.", cloudFoundryEndpoint), e);
            }
            catch (IOException e) {
                throw new ExternalServiceException(String.format("Could not connect to CloudFoundryDashboardManagementEndpoint '%s'.", cloudFoundryEndpoint), e);
            }
            InputStream input = connection.getInputStream();
            try {
                int responseCode = connection.getResponseCode();
                LOGGER.debug("Call to CloudFoundryDashboardManagementEndpoint '{}' complete, response code : {}", (Object)cloudFoundryEndpoint, (Object)responseCode);
                Map responseMap = (Map)this._objectMapper.readValue(input, Map.class);
                Object mayManageObject = responseMap.get("manage");
                if (mayManageObject == null || !(mayManageObject instanceof Boolean)) {
                    throw new ExternalServiceException("CloudFoundryDashboardManagementEndpoint response did not contain \"manage\" entry.");
                }
                bl = (Boolean)mayManageObject;
                if (input == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonProcessingException e) {
                    throw new ExternalServiceException(String.format("CloudFoundryDashboardManagementEndpoint '%s' did not return json.", cloudFoundryEndpoint), e);
                }
                catch (SocketTimeoutException e) {
                    throw new ExternalServiceTimeoutException(String.format("Timed out reading from CloudFoundryDashboardManagementEndpoint '%s'.", cloudFoundryEndpoint), e);
                }
                catch (IOException e) {
                    throw new ExternalServiceException(String.format("Connection to CloudFoundryDashboardManagementEndpoint '%s' failed.", cloudFoundryEndpoint), e);
                }
            }
            input.close();
        }
        return bl;
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    private CompletableFuture<Void> activate() {
        this.setState(State.ACTIVE);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public URI getCloudFoundryEndpointURI() {
        return this._cloudFoundryEndpointURI;
    }

    @Override
    public TrustStore getTrustStore() {
        return this._trustStore;
    }

    @Override
    public Map<String, String> getServiceToManagementGroupMapping() {
        return this._serviceToManagementGroupMapping;
    }

    @Override
    public List<String> getTlsProtocolAllowList() {
        return this._tlsProtocolAllowList;
    }

    @Override
    public List<String> getTlsProtocolDenyList() {
        return this._tlsProtocolDenyList;
    }

    @Override
    public List<String> getTlsCipherSuiteAllowList() {
        return this._tlsCipherSuiteAllowList;
    }

    @Override
    public List<String> getTlsCipherSuiteDenyList() {
        return this._tlsCipherSuiteDenyList;
    }
}

