/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.server.store.berkeleydb.Committer;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoalescingCommiter
implements Committer {
    private final CommitThread _commitThread;

    public CoalescingCommiter(String name, int commiterNotifyThreshold, long commiterWaitTimeout, EnvironmentFacade environmentFacade) {
        this._commitThread = new CommitThread("Commit-Thread-" + name, commiterNotifyThreshold, commiterWaitTimeout, environmentFacade);
    }

    @Override
    public void start() {
        this._commitThread.start();
    }

    @Override
    public void stop() {
        this._commitThread.close();
        if (Thread.currentThread() != this._commitThread) {
            try {
                this._commitThread.join();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Commit thread has not shutdown", ie);
            }
        }
    }

    @Override
    public void commit(Transaction tx, boolean syncCommit) {
        if (syncCommit) {
            SynchronousCommitThreadJob job = new SynchronousCommitThreadJob();
            this._commitThread.addJob(job, true);
            job.awaitCompletion();
        }
    }

    @Override
    public <X> CompletableFuture<X> commitAsync(Transaction tx, X val) {
        ThreadNotifyingSettableFuture future = new ThreadNotifyingSettableFuture();
        BDBCommitFutureResult<X> commitFuture = new BDBCommitFutureResult<X>(val, future);
        this._commitThread.addJob(commitFuture, false);
        return future;
    }

    private static class CommitThread
    extends Thread {
        private static final Logger LOGGER = LoggerFactory.getLogger(CommitThread.class);
        private final int _jobQueueNotifyThreshold;
        private final long _commiterWaitTimeout;
        private final AtomicBoolean _stopped = new AtomicBoolean(false);
        private final Queue<CommitThreadJob> _jobQueue = new ConcurrentLinkedQueue<CommitThreadJob>();
        private final Object _lock = new Object();
        private final EnvironmentFacade _environmentFacade;
        private final List<CommitThreadJob> _inProcessJobs = new ArrayList<CommitThreadJob>(256);

        public CommitThread(String name, int commiterNotifyThreshold, long commiterWaitTimeout, EnvironmentFacade environmentFacade) {
            super(name);
            this._jobQueueNotifyThreshold = commiterNotifyThreshold;
            this._commiterWaitTimeout = commiterWaitTimeout;
            this._environmentFacade = environmentFacade;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void explicitNotify() {
            Object object = this._lock;
            synchronized (object) {
                this._lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this._stopped.get()) {
                Object object = this._lock;
                synchronized (object) {
                    while (!this._stopped.get() && !this.hasJobs()) {
                        try {
                            this._lock.wait(this._commiterWaitTimeout);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.processJobs();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processJobs() {
            int completedJobsIndex;
            CommitThreadJob job;
            while ((job = this._jobQueue.poll()) != null) {
                this._inProcessJobs.add(job);
            }
            try {
                long startTime = 0L;
                if (LOGGER.isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                this._environmentFacade.flushLog();
                if (LOGGER.isDebugEnabled()) {
                    long duration = System.currentTimeMillis() - startTime;
                    LOGGER.debug("flushLog completed in " + duration + " ms");
                }
                while (completedJobsIndex < this._inProcessJobs.size()) {
                    this._inProcessJobs.get(completedJobsIndex).complete();
                    ++completedJobsIndex;
                }
            }
            catch (RuntimeException e) {
                try {
                    LOGGER.error("Exception during environment log flush", (Throwable)e);
                    for (completedJobsIndex = 0; completedJobsIndex < this._inProcessJobs.size(); ++completedJobsIndex) {
                        CommitThreadJob commit = this._inProcessJobs.get(completedJobsIndex);
                        commit.abort(e);
                    }
                }
                finally {
                    this._environmentFacade.flushLogFailed(e);
                }
            }
            finally {
                this._inProcessJobs.clear();
            }
        }

        private boolean hasJobs() {
            return !this._jobQueue.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addJob(CommitThreadJob commit, boolean sync) {
            if (this._stopped.get()) {
                throw new IllegalStateException("Commit thread is stopped");
            }
            this._jobQueue.add(commit);
            if (sync || this._jobQueue.size() >= this._jobQueueNotifyThreshold) {
                Object object = this._lock;
                synchronized (object) {
                    this._lock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this._lock;
            synchronized (object) {
                block7: {
                    this._stopped.set(true);
                    try {
                        CommitThreadJob commit;
                        this._environmentFacade.flushLog();
                        while ((commit = this._jobQueue.poll()) != null) {
                            commit.complete();
                        }
                    }
                    catch (RuntimeException flushException) {
                        CommitThreadJob commit;
                        RuntimeException e = new RuntimeException("Commit thread has been closed, transaction aborted");
                        int abortedCommits = 0;
                        while ((commit = this._jobQueue.poll()) != null) {
                            ++abortedCommits;
                            commit.abort(e);
                        }
                        if (!LOGGER.isDebugEnabled() || abortedCommits <= 0) break block7;
                        LOGGER.debug(abortedCommits + " commit(s) were aborted during close.");
                    }
                }
                this._lock.notifyAll();
            }
        }
    }

    private static class SynchronousCommitThreadJob
    implements CommitThreadJob {
        private boolean _done;
        private RuntimeException _exception;

        private SynchronousCommitThreadJob() {
        }

        @Override
        public synchronized void complete() {
            this._done = true;
            this.notifyAll();
        }

        @Override
        public synchronized void abort(RuntimeException e) {
            this._done = true;
            this._exception = e;
            this.notifyAll();
        }

        public synchronized void awaitCompletion() {
            boolean interrupted = false;
            while (!this._done) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (this._exception != null) {
                throw this._exception;
            }
        }
    }

    private static interface CommitThreadJob {
        public void complete();

        public void abort(RuntimeException var1);
    }

    private final class ThreadNotifyingSettableFuture<X>
    extends CompletableFuture<X> {
        private ThreadNotifyingSettableFuture() {
        }

        @Override
        public X get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
            if (!this.isDone()) {
                CoalescingCommiter.this._commitThread.explicitNotify();
            }
            return (X)super.get(timeout, unit);
        }

        @Override
        public X get() throws InterruptedException, ExecutionException {
            if (!this.isDone()) {
                CoalescingCommiter.this._commitThread.explicitNotify();
            }
            return (X)super.get();
        }

        @Override
        public boolean complete(X value) {
            return super.complete(value);
        }

        @Override
        public boolean completeExceptionally(Throwable throwable) {
            return super.completeExceptionally(throwable);
        }
    }

    private static final class BDBCommitFutureResult<X>
    implements CommitThreadJob {
        private final X _value;
        private final ThreadNotifyingSettableFuture<X> _future;

        public BDBCommitFutureResult(X value, ThreadNotifyingSettableFuture<X> future) {
            this._value = value;
            this._future = future;
        }

        @Override
        public void complete() {
            this._future.complete(this._value);
        }

        @Override
        public void abort(RuntimeException databaseException) {
            this._future.completeExceptionally(databaseException);
        }
    }
}

