/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth;

import java.security.AccessController;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.security.QpidPrincipal;

public final class AuthenticatedPrincipal
implements QpidPrincipal {
    private static final long serialVersionUID = 1L;
    private final Principal _wrappedPrincipal;

    public AuthenticatedPrincipal(Principal wrappedPrincipal) {
        if (wrappedPrincipal == null) {
            throw new IllegalArgumentException("Wrapped principal is null");
        }
        this._wrappedPrincipal = wrappedPrincipal;
    }

    public static AuthenticatedPrincipal getCurrentUser() {
        Set<AuthenticatedPrincipal> principals;
        Subject subject = Subject.getSubject(AccessController.getContext());
        AuthenticatedPrincipal user = subject != null ? (!(principals = subject.getPrincipals(AuthenticatedPrincipal.class)).isEmpty() ? principals.iterator().next() : null) : null;
        return user;
    }

    @Override
    public ConfiguredObject<?> getOrigin() {
        if (this._wrappedPrincipal instanceof QpidPrincipal) {
            return ((QpidPrincipal)this._wrappedPrincipal).getOrigin();
        }
        return null;
    }

    @Override
    public String getName() {
        return this._wrappedPrincipal.getName();
    }

    @Override
    public int hashCode() {
        return this._wrappedPrincipal.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthenticatedPrincipal)) {
            return false;
        }
        AuthenticatedPrincipal other = (AuthenticatedPrincipal)obj;
        return this._wrappedPrincipal.equals(other._wrappedPrincipal);
    }

    public static AuthenticatedPrincipal getOptionalAuthenticatedPrincipalFromSubject(Subject authSubject) {
        return AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject(authSubject, true);
    }

    public static AuthenticatedPrincipal getAuthenticatedPrincipalFromSubject(Subject authSubject) {
        return AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject(authSubject, false);
    }

    private static AuthenticatedPrincipal getAuthenticatedPrincipalFromSubject(Subject authSubject, boolean isPrincipalOptional) {
        return QpidPrincipal.getSingletonPrincipal(authSubject, isPrincipalOptional, AuthenticatedPrincipal.class);
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

