/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;

public class FileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCES_PREFIX = "/resources";
    private static final Map<String, String> CONTENT_TYPES = Map.of("js", "application/javascript", "html", "text/html", "css", "text/css", "json", "application/json", "jpg", "image/jpg", "png", "image/png", "gif", "image/gif", "svg", "image/svg+xml");
    private final String _resourcePathPrefix;
    private final boolean _usePathInfo;

    public FileServlet() {
        this(RESOURCES_PREFIX, false);
    }

    public FileServlet(String resourcePathPrefix, boolean usePathInfo) {
        this._resourcePathPrefix = resourcePathPrefix;
        this._usePathInfo = usePathInfo;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block15: {
            URL resourceURL;
            String suffix;
            String contentType;
            String filename = this._usePathInfo ? request.getPathInfo() : request.getServletPath();
            if (filename.contains(".") && (contentType = CONTENT_TYPES.get(suffix = filename.substring(filename.lastIndexOf(46) + 1))) != null) {
                response.setContentType(contentType);
            }
            if ((resourceURL = ((Object)((Object)this)).getClass().getResource(this._resourcePathPrefix + filename)) != null && !filename.contains("..")) {
                response.setStatus(200);
                try (InputStream fileInput = resourceURL.openStream();
                     OutputStream output = HttpManagementUtil.getOutputStream(request, response);){
                    int read;
                    byte[] buffer = new byte[1024];
                    while ((read = fileInput.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                    break block15;
                }
            }
            response.sendError(404, "unknown file");
        }
    }
}

