/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.factory;

import java.util.List;
import java.util.Objects;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.accessor.ChainedObjectAccessor;
import org.apache.qpid.server.query.engine.parsing.expression.accessor.DelegatingCollectionAccessorExpression;
import org.apache.qpid.server.query.engine.parsing.expression.accessor.DelegatingObjectAccessor;
import org.apache.qpid.server.query.engine.parsing.expression.literal.StringLiteralExpression;

public final class AccessorExpressionFactory {
    private AccessorExpressionFactory() {
    }

    public static <T, R> ExpressionNode<T, R> delegating(String alias, String property) {
        Objects.requireNonNull(property, "Property name should be not null");
        return new DelegatingObjectAccessor(alias, property);
    }

    public static <T, R> ExpressionNode<T, R> chained(String alias, ExpressionNode<T, R> first, List<ExpressionNode<R, ?>> args) {
        Objects.requireNonNull(first, "Child expression should be not null");
        if (args == null || args.isEmpty()) {
            if (first instanceof StringLiteralExpression) {
                return new DelegatingObjectAccessor(alias, (String)first.apply(null));
            }
            if (first instanceof DelegatingObjectAccessor) {
                return first;
            }
        }
        return new ChainedObjectAccessor<T, R>(alias, first, args);
    }

    public static <T, R> ExpressionNode<T, R> collection(String alias, String property, Expression<T, R> index) {
        Objects.requireNonNull(property, "Property name should be not null");
        Objects.requireNonNull(index, "Index value should be not null");
        return new DelegatingCollectionAccessorExpression(alias, property, index);
    }
}

