/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.retriever;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.qpid.server.model.BrokerConnectionLimitProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.query.engine.retriever.ConfiguredObjectRetriever;
import org.apache.qpid.server.query.engine.retriever.EntityRetriever;
import org.apache.qpid.server.security.limit.ConnectionLimitProvider;
import org.apache.qpid.server.user.connection.limits.plugins.ConnectionLimitRule;
import org.apache.qpid.server.user.connection.limits.plugins.FileBasedBrokerConnectionLimitProvider;
import org.apache.qpid.server.user.connection.limits.plugins.RuleBasedBrokerConnectionLimitProvider;

public class ConnectionLimitRuleRetriever<C extends ConfiguredObject<?>>
extends ConfiguredObjectRetriever<C>
implements EntityRetriever<C> {
    private final Class<C> _type = BrokerConnectionLimitProvider.class;
    private final List<String> _fieldNames = List.of("blocked", "countLimit", "frequencyLimit", "frequencyPeriod", "identity", "port");
    private final Function<ConnectionLimitRule, Map<String, Object>> _connectionLimitRuleMapping = rule -> Map.of(this._fieldNames.get(0), rule.getBlocked(), this._fieldNames.get(1), rule.getCountLimit(), this._fieldNames.get(2), rule.getFrequencyLimit(), this._fieldNames.get(3), rule.getFrequencyPeriod(), this._fieldNames.get(4), rule.getIdentity(), this._fieldNames.get(5), rule.getPort());

    @Override
    public Stream<Map<String, ?>> retrieve(C broker) {
        Stream<ConnectionLimitProvider> stream = this.retrieve(broker, this._type).map(child -> (BrokerConnectionLimitProvider)child);
        return stream.flatMap(provider -> {
            if (provider instanceof FileBasedBrokerConnectionLimitProvider) {
                return ((FileBasedBrokerConnectionLimitProvider)provider).getRules().stream().map(this._connectionLimitRuleMapping);
            }
            if (provider instanceof RuleBasedBrokerConnectionLimitProvider) {
                return ((RuleBasedBrokerConnectionLimitProvider)provider).getRules().stream().map(this._connectionLimitRuleMapping);
            }
            return Stream.empty();
        });
    }

    @Override
    public List<String> getFieldNames() {
        return this._fieldNames;
    }
}

