/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.util.LogVerificationException;
import com.sleepycat.je.util.LogVerificationReadableByteChannel;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

public class DbVerifyLog {
    private static final String USAGE = "usage: " + CmdUtil.getJavaCommand(DbVerifyLog.class) + "\n" + "   [-h <dir>]  # environment home directory\n" + "   [-s <file>] # starting (minimum) file number\n" + "   [-e <file>] # ending (one past the maximum) file number\n" + "   [-V]        # print JE version number";
    private final EnvironmentImpl envImpl;
    private final int readBufferSize;
    private volatile boolean stopVerify = false;

    public DbVerifyLog(Environment env) {
        this(env, 0);
    }

    public DbVerifyLog(Environment env, int readBufferSize) {
        this(DbInternal.getNonNullEnvImpl(env), readBufferSize);
    }

    public DbVerifyLog(EnvironmentImpl envImpl, int readBufferSize) {
        this.readBufferSize = readBufferSize > 0 ? readBufferSize : envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.envImpl = envImpl;
    }

    public void verifyAll() throws LogVerificationException, IOException {
        this.verify(0L, Long.MAX_VALUE);
    }

    public void verify(long startFile, long endFile) throws LogVerificationException, IOException {
        FileManager fileManager = this.envImpl.getFileManager();
        File homeDir = this.envImpl.getEnvironmentHome();
        String[] fileNames = fileManager.listFileNames(startFile, endFile - 1L);
        ByteBuffer buf = ByteBuffer.allocateDirect(this.readBufferSize);
        for (String fileName : fileNames) {
            FileInputStream fis;
            if (this.stopVerify) {
                return;
            }
            File file = new File(homeDir, fileName);
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException fne) {
                continue;
            }
            FileChannel fic = fis.getChannel();
            LogVerificationReadableByteChannel vic = new LogVerificationReadableByteChannel(this.envImpl, (ReadableByteChannel)fic, fileName);
            IOException ioe = null;
            try {
                while (vic.read(buf) != -1) {
                    buf.clear();
                }
            }
            catch (IOException e) {
                ioe = e;
                throw ioe;
            }
            finally {
                block14: {
                    try {
                        fis.close();
                        vic.close();
                    }
                    catch (IOException e) {
                        if (ioe != null) break block14;
                        throw e;
                    }
                }
            }
        }
    }

    public static void main(String[] argv) {
        try {
            File envHome = new File(".");
            long startFile = 0L;
            long endFile = Long.MAX_VALUE;
            for (int whichArg = 0; whichArg < argv.length; ++whichArg) {
                String arg;
                int slashOff;
                String nextArg = argv[whichArg];
                if (nextArg.equals("-h")) {
                    envHome = new File(CmdUtil.getArg(argv, ++whichArg));
                    continue;
                }
                if (nextArg.equals("-s")) {
                    if ((slashOff = (arg = CmdUtil.getArg(argv, ++whichArg)).indexOf("/")) >= 0) {
                        arg = arg.substring(0, slashOff);
                    }
                    startFile = CmdUtil.readLongNumber(arg);
                    continue;
                }
                if (nextArg.equals("-e")) {
                    if ((slashOff = (arg = CmdUtil.getArg(argv, ++whichArg)).indexOf("/")) >= 0) {
                        arg = arg.substring(0, slashOff);
                    }
                    endFile = CmdUtil.readLongNumber(arg);
                    continue;
                }
                if (nextArg.equals("-V")) {
                    System.out.println(JEVersion.CURRENT_VERSION);
                    System.exit(0);
                    continue;
                }
                DbVerifyLog.printUsageAndExit("Unknown argument: " + nextArg);
            }
            EnvironmentImpl envImpl = CmdUtil.makeUtilityEnvironment(envHome, true);
            DbVerifyLog verifier = new DbVerifyLog(envImpl, 0);
            verifier.verify(startFile, endFile);
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            DbVerifyLog.printUsageAndExit(e.toString());
        }
    }

    private static void printUsageAndExit(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(USAGE);
        System.exit(1);
    }

    public void setStopVerifyFlag() {
        this.stopVerify = true;
    }
}

