/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAlias;

public class UUIDGenerator {
    public static UUID generateRandomUUID() {
        return UUID.randomUUID();
    }

    private static UUID createUUID(String objectType, String ... names) {
        StringBuilder sb = new StringBuilder();
        sb.append(objectType);
        for (String name : names) {
            sb.append("/").append(name);
        }
        return UUID.nameUUIDFromBytes(sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static UUID generateExchangeUUID(String exchangeName, String virtualHostName) {
        return UUIDGenerator.createUUID(Exchange.class.getName(), virtualHostName, exchangeName);
    }

    public static UUID generateQueueUUID(String queueName, String virtualHostName) {
        return UUIDGenerator.createUUID(Queue.class.getName(), virtualHostName, queueName);
    }

    public static UUID generateBindingUUID(String exchangeName, String queueName, String bindingKey, String virtualHostName) {
        return UUIDGenerator.createUUID(Binding.class.getName(), virtualHostName, exchangeName, queueName, bindingKey);
    }

    public static UUID generateUserUUID(String authenticationProviderName, String userName) {
        return UUIDGenerator.createUUID(User.class.getName(), authenticationProviderName, userName);
    }

    public static UUID generateGroupUUID(String groupProviderName, String groupName) {
        return UUIDGenerator.createUUID(Group.class.getName(), groupProviderName, groupName);
    }

    public static UUID generateVhostUUID(String virtualHostName) {
        return UUIDGenerator.createUUID(VirtualHost.class.getName(), virtualHostName);
    }

    public static UUID generateVhostAliasUUID(String virtualHostName, String portName) {
        return UUIDGenerator.createUUID(VirtualHostAlias.class.getName(), virtualHostName, portName);
    }

    public static UUID generateConsumerUUID(String virtualHostName, String queueName, String connectionRemoteAddress, String channelNumber, String consumerName) {
        return UUIDGenerator.createUUID(Consumer.class.getName(), virtualHostName, queueName, connectionRemoteAddress, channelNumber, consumerName);
    }

    public static UUID generateGroupMemberUUID(String groupProviderName, String groupName, String groupMemberName) {
        return UUIDGenerator.createUUID(GroupMember.class.getName(), groupProviderName, groupName, groupMemberName);
    }

    public static UUID generateBrokerChildUUID(String type, String childName) {
        return UUIDGenerator.createUUID(type, childName);
    }
}

