/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.MemoryMessageStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreProvider;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;

public abstract class AbstractMemoryStore
implements DurableConfigurationStore,
MessageStoreProvider {
    private final MessageStore _messageStore = new MemoryMessageStore();
    private final Class<? extends ConfiguredObject> _rootClass;
    private State _state = State.CLOSED;
    private final Object _lock = new Object();
    private final ConcurrentMap<UUID, ConfiguredObjectRecord> _configuredObjectRecords = new ConcurrentHashMap<UUID, ConfiguredObjectRecord>();

    protected AbstractMemoryStore(Class<? extends ConfiguredObject> rootClass) {
        this._rootClass = rootClass;
    }

    @Override
    public void create(ConfiguredObjectRecord record) {
        this.assertState(State.OPEN);
        if (this._configuredObjectRecords.putIfAbsent(record.getId(), record) != null) {
            throw new StoreException("Record with id " + String.valueOf(record.getId()) + " is already present");
        }
    }

    @Override
    public void update(boolean createIfNecessary, ConfiguredObjectRecord ... records) {
        this.assertState(State.OPEN);
        for (ConfiguredObjectRecord record : records) {
            if (createIfNecessary) {
                this._configuredObjectRecords.put(record.getId(), record);
                continue;
            }
            ConfiguredObjectRecord previousValue = this._configuredObjectRecords.replace(record.getId(), record);
            if (previousValue != null) continue;
            throw new StoreException("Record with id " + String.valueOf(record.getId()) + " does not exist");
        }
    }

    @Override
    public UUID[] remove(ConfiguredObjectRecord ... objects) {
        this.assertState(State.OPEN);
        ArrayList<UUID> removed = new ArrayList<UUID>();
        for (ConfiguredObjectRecord record : objects) {
            if (this._configuredObjectRecords.remove(record.getId()) == null) continue;
            removed.add(record.getId());
        }
        return removed.toArray(new UUID[removed.size()]);
    }

    @Override
    public void init(ConfiguredObject<?> parent) {
        this.changeState(State.CLOSED, State.CONFIGURED);
    }

    @Override
    public void upgradeStoreStructure() throws StoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConfigurationStore() {
        Object object = this._lock;
        synchronized (object) {
            this._state = State.CLOSED;
        }
        this._configuredObjectRecords.clear();
    }

    @Override
    public boolean openConfigurationStore(ConfiguredObjectRecordHandler handler, ConfiguredObjectRecord ... initialRecords) throws StoreException {
        this.changeState(State.CONFIGURED, State.OPEN);
        boolean isNew = this._configuredObjectRecords.isEmpty();
        if (isNew) {
            for (ConfiguredObjectRecord record : initialRecords) {
                this._configuredObjectRecords.put(record.getId(), record);
            }
        }
        for (ConfiguredObjectRecord record : this._configuredObjectRecords.values()) {
            handler.handle(record);
        }
        return isNew;
    }

    @Override
    public void reload(ConfiguredObjectRecordHandler handler) throws StoreException {
        this.assertState(State.OPEN);
        for (ConfiguredObjectRecord record : this._configuredObjectRecords.values()) {
            handler.handle(record);
        }
    }

    @Override
    public MessageStore getMessageStore() {
        return this._messageStore;
    }

    @Override
    public void onDelete(ConfiguredObject<?> parent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertState(State state) {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != state) {
                throw new IllegalStateException("The store must be in state " + String.valueOf((Object)state) + " to perform this operation, but it is in state " + String.valueOf((Object)this._state) + " instead");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State oldState, State newState) {
        Object object = this._lock;
        synchronized (object) {
            this.assertState(oldState);
            this._state = newState;
        }
    }

    public List<ConfiguredObjectRecord> getConfiguredObjectRecords() {
        return new ArrayList<ConfiguredObjectRecord>(this._configuredObjectRecords.values());
    }

    static enum State {
        CLOSED,
        CONFIGURED,
        OPEN;

    }
}

