/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.utilint.Timestamp;
import java.nio.ByteBuffer;
import java.util.Calendar;

public class CheckpointStart
implements Loggable {
    private Timestamp startTime;
    private long id;
    private String invoker;

    public CheckpointStart(long id, String invoker) {
        Calendar cal = Calendar.getInstance();
        this.startTime = new Timestamp(cal.getTime().getTime());
        this.id = id;
        this.invoker = invoker == null ? "" : invoker;
    }

    public CheckpointStart() {
    }

    @Override
    public int getLogSize() {
        return LogUtils.getTimestampLogSize(this.startTime) + LogUtils.getPackedLongLogSize(this.id) + LogUtils.getStringLogSize(this.invoker);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeTimestamp(logBuffer, this.startTime);
        LogUtils.writePackedLong(logBuffer, this.id);
        LogUtils.writeString(logBuffer, this.invoker);
    }

    @Override
    public void readFromLog(ByteBuffer logBuffer, int entryVersion) {
        boolean unpacked = entryVersion < 6;
        this.startTime = LogUtils.readTimestamp(logBuffer, unpacked);
        this.id = LogUtils.readLong(logBuffer, unpacked);
        this.invoker = LogUtils.readString(logBuffer, unpacked, entryVersion);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<CkptStart invoker=\"").append(this.invoker);
        sb.append("\" time=\"").append(this.startTime);
        sb.append("\" id=\"").append(this.id);
        sb.append("\"/>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }
}

