/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.qpid.protonj2.client.NextReceiverPolicy;
import org.apache.qpid.protonj2.client.Receiver;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientReceiver;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.engine.IncomingDelivery;

final class ClientNextReceiverSelector {
    private static final String LAST_RETURNED_STATE_KEY = "Last_Returned_State";
    private final ArrayDeque<ClientFuture<Receiver>> pending = new ArrayDeque();
    private final ClientSession session;
    private SecureRandom srand;

    public ClientNextReceiverSelector(ClientSession session) {
        this.session = session;
        this.handleReconnect();
    }

    public void nextReceiver(ClientFuture<Receiver> request, NextReceiverPolicy policy, long timeout) {
        Objects.requireNonNull(policy, "The next receiver selection policy cannot be null");
        ClientReceiver result = null;
        switch (policy) {
            case ROUND_ROBIN: {
                result = this.selectNextAvailable();
                break;
            }
            case FIRST_AVAILABLE: {
                result = this.selectFirstAvailable();
                break;
            }
            case LARGEST_BACKLOG: {
                result = this.selectLargestBacklog();
                break;
            }
            case SMALLEST_BACKLOG: {
                result = this.selectSmallestBacklog();
                break;
            }
            case RANDOM: {
                result = this.selectRandomReceiver();
                break;
            }
            default: {
                request.failed(new ClientException("Next receiver called with invalid or unknown policy:" + String.valueOf((Object)policy)));
            }
        }
        if (result == null) {
            this.pending.add(request);
            if (timeout > 0L) {
                this.session.getScheduler().schedule(() -> {
                    if (!request.isDone()) {
                        this.pending.remove(request);
                        request.complete(null);
                    }
                }, timeout, TimeUnit.MILLISECONDS);
            }
        } else {
            result.protonLink().getSession().getAttachments().set(LAST_RETURNED_STATE_KEY, (Object)result);
            request.complete(result);
        }
    }

    public void handleReconnect() {
        this.session.getProtonSession().deliveryReadHandler(this::deliveryReadHandler);
    }

    public void handleShutdown() {
        ClientException cause = null;
        cause = this.session.isClosed() ? new ClientIllegalStateException("The Session was explicitly closed", this.session.getFailureCause()) : (this.session.getFailureCause() != null ? this.session.getFailureCause() : new ClientIllegalStateException("The session was closed without a specific error being provided"));
        for (ClientFuture<Receiver> request : this.pending) {
            request.failed(cause);
        }
        this.pending.clear();
    }

    private ClientReceiver selectRandomReceiver() {
        ArrayList candidates = this.session.getProtonSession().receivers().stream().filter(r -> r.getLinkedResource() instanceof ClientReceiver && ((ClientReceiver)r.getLinkedResource(ClientReceiver.class)).queuedDeliveries() > 0L).map(r -> (ClientReceiver)r.getLinkedResource()).collect(Collectors.toCollection(ArrayList::new));
        if (this.srand == null) {
            this.srand = new SecureRandom();
        }
        Collections.shuffle(candidates, this.srand);
        return candidates.isEmpty() ? null : (ClientReceiver)candidates.get(0);
    }

    private ClientReceiver selectNextAvailable() {
        ClientReceiver lastReceiver = (ClientReceiver)this.session.getProtonSession().getAttachments().get(LAST_RETURNED_STATE_KEY);
        ClientReceiver result = null;
        if (lastReceiver != null && !lastReceiver.protonReceiver.isLocallyClosedOrDetached()) {
            boolean foundLast = false;
            for (org.apache.qpid.protonj2.engine.Receiver protonReceover : this.session.getProtonSession().receivers()) {
                if (!(protonReceover.getLinkedResource() instanceof ClientReceiver)) continue;
                if (foundLast) {
                    ClientReceiver candidate = (ClientReceiver)protonReceover.getLinkedResource();
                    if (candidate.queuedDeliveries() <= 0L) continue;
                    result = candidate;
                    continue;
                }
                foundLast = protonReceover.getLinkedResource() == lastReceiver;
            }
        } else {
            this.session.getProtonSession().getAttachments().set(LAST_RETURNED_STATE_KEY, null);
        }
        return result != null ? result : this.selectFirstAvailable();
    }

    private ClientReceiver selectFirstAvailable() {
        return this.session.getProtonSession().receivers().stream().filter(r -> r.getLinkedResource() instanceof ClientReceiver && ((ClientReceiver)r.getLinkedResource(ClientReceiver.class)).queuedDeliveries() > 0L).map(r -> (ClientReceiver)r.getLinkedResource()).findFirst().orElse(null);
    }

    private ClientReceiver selectLargestBacklog() {
        return this.session.getProtonSession().receivers().stream().filter(r -> r.getLinkedResource() instanceof ClientReceiver && ((ClientReceiver)r.getLinkedResource(ClientReceiver.class)).queuedDeliveries() > 0L).map(r -> (ClientReceiver)r.getLinkedResource()).max(Comparator.comparingLong(ClientReceiver::queuedDeliveries)).orElse(null);
    }

    private ClientReceiver selectSmallestBacklog() {
        return this.session.getProtonSession().receivers().stream().filter(r -> r.getLinkedResource() instanceof ClientReceiver && ((ClientReceiver)r.getLinkedResource(ClientReceiver.class)).queuedDeliveries() > 0L).map(r -> (ClientReceiver)r.getLinkedResource()).min(Comparator.comparingLong(ClientReceiver::queuedDeliveries)).orElse(null);
    }

    private void deliveryReadHandler(IncomingDelivery delivery) {
        if (!this.pending.isEmpty() && !delivery.isPartial() && !delivery.isAborted() && delivery.getLink().getLinkedResource() instanceof ClientReceiver) {
            ClientReceiver receiver = (ClientReceiver)delivery.getLink().getLinkedResource();
            delivery.getLink().getSession().getAttachments().set(LAST_RETURNED_STATE_KEY, (Object)receiver);
            this.pending.poll().complete(receiver);
        }
    }
}

