/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.types.UnsignedInteger;

public class UnsettledMap<Delivery>
implements Map<UnsignedInteger, Delivery> {
    private final double BUCKET_LOAD_FACTOR_MULTIPLIER = 0.3;
    private static final int UNSETTLED_INITIAL_BUCKETS = 2;
    private static final int UNSETTLED_BUCKET_SIZE = 256;
    private final UnsettledBucket<Delivery> ALWAYS_FULL_BUCKET = new UnsettledBucket();
    private final UnsettledGetDeliveryId<Delivery> deliveryIdSupplier;
    private final int bucketCapacity;
    private final int bucketLowWaterMark;
    private int totalEntries;
    private int modCount;
    private int current;
    private UnsettledBucket<Delivery>[] buckets;
    protected Set<UnsignedInteger> keySet;
    protected Collection<Delivery> values;
    protected Set<Map.Entry<UnsignedInteger, Delivery>> entrySet;

    public UnsettledMap(UnsettledGetDeliveryId<Delivery> idSupplier) {
        this(idSupplier, 2, 256);
    }

    public UnsettledMap(UnsettledGetDeliveryId<Delivery> idSupplier, int initialBuckets) {
        this(idSupplier, initialBuckets, 256);
    }

    public UnsettledMap(UnsettledGetDeliveryId<Delivery> idSupplier, int initialBuckets, int bucketSize) {
        this.deliveryIdSupplier = idSupplier;
        this.bucketCapacity = bucketSize;
        this.bucketLowWaterMark = (int)((double)bucketSize * 0.3);
        if (bucketSize < 1) {
            throw new IllegalArgumentException("The bucket size must be greater than zero");
        }
        if (initialBuckets < 1) {
            throw new IllegalArgumentException("The initial number of buckets must be at least 1");
        }
        this.buckets = new UnsettledBucket[initialBuckets];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new UnsettledBucket<Delivery>(bucketSize, this.deliveryIdSupplier);
        }
    }

    @Override
    public void putAll(Map<? extends UnsignedInteger, ? extends Delivery> source) {
        source.entrySet().forEach((? super T entry) -> this.put((UnsignedInteger)entry.getKey(), entry.getValue()));
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.buckets.length && this.buckets[i].isReadable(); ++i) {
            this.buckets[i].clear();
        }
        this.totalEntries = 0;
        this.current = 0;
    }

    @Override
    public Delivery put(UnsignedInteger key, Delivery value) {
        return this.put(key.intValue(), value);
    }

    @Override
    public Delivery put(int deliveryId, Delivery delivery) {
        if (!this.buckets[this.current].put(deliveryId, delivery)) {
            if (++this.current == this.buckets.length) {
                this.buckets = Arrays.copyOf(this.buckets, this.current + 1);
                this.buckets[this.current] = new UnsettledBucket<Delivery>(this.bucketCapacity, this.deliveryIdSupplier);
            }
            this.buckets[this.current].put(deliveryId, delivery);
        }
        ++this.totalEntries;
        ++this.modCount;
        return null;
    }

    @Override
    public int size() {
        return this.totalEntries;
    }

    @Override
    public boolean isEmpty() {
        return this.totalEntries == 0;
    }

    @Override
    public Delivery get(Object key) {
        return this.get(((Number)Number.class.cast(key)).intValue());
    }

    public Delivery get(int deliveryId) {
        if (this.totalEntries > 0) {
            for (int i = 0; i <= this.current; ++i) {
                Delivery result;
                if (!this.buckets[i].isInRange(deliveryId) || (result = this.buckets[i].get(deliveryId)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public Delivery remove(Object key) {
        return this.removeValue(((Number)Number.class.cast(key)).intValue());
    }

    public Delivery remove(int deliveryId) {
        return this.removeValue(deliveryId);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(((Number)Number.class.cast(key)).intValue());
    }

    public boolean containsKey(int key) {
        if (this.totalEntries > 0) {
            for (int i = 0; i <= this.current; ++i) {
                if (!this.buckets[i].isInRange(key) || this.buckets[i].get(key) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.totalEntries > 0 && value != null) {
            for (int i = 0; i <= this.current; ++i) {
                for (int j = this.buckets[i].readOffset; j < this.buckets[i].writeOffset; ++j) {
                    if (!value.equals(this.buckets[i].entryAt(j))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void forEach(Consumer<Delivery> action) {
        Objects.requireNonNull(action);
        if (this.totalEntries > 0) {
            for (int i = 0; i <= this.current; ++i) {
                for (int j = this.buckets[i].readOffset; j < this.buckets[i].writeOffset; ++j) {
                    action.accept(this.buckets[i].entryAt(j));
                }
            }
        }
    }

    public void forEach(int first, int last, Consumer<Delivery> action) {
        Objects.requireNonNull(action);
        if (this.totalEntries == 0) {
            return;
        }
        boolean foundFirst = false;
        boolean foundLast = false;
        for (int i = 0; i <= this.current && !foundLast; ++i) {
            if (!foundFirst && !this.buckets[i].isInRange(first)) continue;
            for (int j = this.buckets[i].readOffset; j < this.buckets[i].writeOffset && !foundLast; ++j) {
                Delivery delivery = this.buckets[i].entryAt(j);
                int deliveryId = this.deliveryIdSupplier.getDeliveryId(delivery);
                foundFirst = foundFirst || deliveryId == first;
                boolean bl = foundLast = deliveryId == last;
                if (!foundFirst) continue;
                action.accept(delivery);
            }
        }
    }

    public void removeEach(int first, int last, Consumer<Delivery> action) {
        Objects.requireNonNull(action);
        if (this.totalEntries == 0) {
            return;
        }
        boolean foundFirst = false;
        boolean foundLast = false;
        int removeStart = 0;
        int removeEnd = 0;
        for (int i = 0; i <= this.current && !foundLast; ++i) {
            if (!foundFirst && !this.buckets[i].isInRange(first)) continue;
            UnsettledBucket<Delivery> bucket = this.buckets[i];
            removeStart = removeEnd = bucket.readOffset;
            int j = removeEnd;
            while (j < bucket.writeOffset && !foundLast) {
                Delivery delivery = bucket.entryAt(j);
                int deliveryId = this.deliveryIdSupplier.getDeliveryId(delivery);
                foundFirst = foundFirst || deliveryId == first;
                boolean bl = foundLast = deliveryId == last;
                if (foundFirst) {
                    action.accept(delivery);
                    removeEnd = ++j;
                    continue;
                }
                removeStart = removeEnd = ++j;
            }
            if (!foundFirst) continue;
            i = this.removeRange(i, removeStart, removeEnd, foundLast) ? --i : i;
        }
    }

    private boolean removeRange(int bucketIndex, int start, int end, boolean compact) {
        UnsettledBucket<Delivery> bucket = this.buckets[bucketIndex];
        int removals = end - start;
        this.totalEntries -= removals;
        ++this.modCount;
        if (removals == bucket.entries) {
            return this.recycleBucket(bucketIndex);
        }
        System.arraycopy(bucket.deliveries, end, bucket.deliveries, start, bucket.writeOffset - end);
        Arrays.fill(bucket.deliveries, bucket.writeOffset - removals, bucket.writeOffset, null);
        bucket.writeOffset -= removals;
        bucket.entries -= removals;
        bucket.highestDeliveryId = bucket.entryIdAt(bucket.writeOffset - 1);
        if (compact) {
            return this.tryCompact(bucketIndex);
        }
        return false;
    }

    @Override
    public void forEach(BiConsumer<? super UnsignedInteger, ? super Delivery> action) {
        Objects.requireNonNull(action);
        if (this.totalEntries > 0) {
            for (int i = 0; i <= this.current; ++i) {
                for (int j = this.buckets[i].readOffset; j < this.buckets[i].writeOffset; ++j) {
                    Delivery delivery = this.buckets[i].entryAt(j);
                    action.accept(UnsignedInteger.valueOf(this.deliveryIdSupplier.getDeliveryId(delivery)), delivery);
                }
            }
        }
    }

    @Override
    public Collection<Delivery> values() {
        if (this.values == null) {
            this.values = new UnsettledTackingMapValues();
        }
        return this.values;
    }

    @Override
    public Set<UnsignedInteger> keySet() {
        if (this.keySet == null) {
            this.keySet = new UnsettledTackingMapKeys();
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<UnsignedInteger, Delivery>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new UnsettledTackingMapEntries();
        }
        return this.entrySet;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (int i = 0; i <= this.current; ++i) {
                for (int j = this.buckets[i].readOffset; j < this.buckets[i].writeOffset; ++j) {
                    Delivery delivery = this.buckets[i].entryAt(j);
                    if (delivery.equals(m.get(this.deliveryIdSupplier.getDeliveryId(delivery)))) continue;
                    return false;
                }
            }
        }
        catch (ClassCastException | NullPointerException ignored) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "UnsettledMap: { size=" + this.totalEntries + " buckets=" + this.buckets.length + " bucket-capacity=" + this.bucketCapacity + " }";
    }

    private boolean recycleBucket(int index) {
        this.buckets[index].clear();
        if (index < this.current) {
            --this.current;
            int next = index + 1;
            UnsettledBucket<Delivery> recycled = this.buckets[index];
            System.arraycopy(this.buckets, next, this.buckets, index, this.buckets.length - next);
            this.buckets[this.buckets.length - 1] = recycled;
            return true;
        }
        return false;
    }

    private Delivery removeValue(int deliveryId) {
        if (this.totalEntries > 0) {
            Delivery result = null;
            for (int i = 0; i <= this.current; ++i) {
                if (!this.buckets[i].isInRange(deliveryId)) continue;
                Delivery Delivery = this.buckets[i].remove(deliveryId);
                result = Delivery;
                if (Delivery == null) continue;
                --this.totalEntries;
                ++this.modCount;
                if (this.buckets[i].entries <= this.bucketLowWaterMark) {
                    this.tryCompact(i);
                }
                return result;
            }
        }
        return null;
    }

    private long removeAt(int bucketIndex, int bucketEntry) {
        if (bucketIndex >= this.buckets.length || bucketEntry >= 256) {
            throw new IndexOutOfBoundsException(String.format("Cannot remove an entry from segment %d at index %d which is outside the tracked bounds", bucketIndex, bucketEntry));
        }
        UnsettledBucket<Delivery> bucket = this.buckets[bucketIndex];
        bucket.removeAt(bucketEntry);
        --this.totalEntries;
        ++this.modCount;
        long result = -1L;
        if (bucket.isReadable()) {
            UnsettledBucket<Delivery> prevBucket;
            int nextBucketIndex = bucketIndex + 1;
            int prevBucketIndex = bucketIndex - 1;
            UnsettledBucket<Delivery> nextBucket = bucketIndex == this.current || Integer.compareUnsigned(bucket.highestDeliveryId, this.buckets[nextBucketIndex].lowestDeliveryId) > 0 ? this.ALWAYS_FULL_BUCKET : this.buckets[nextBucketIndex];
            UnsettledBucket<Delivery> unsettledBucket = prevBucket = bucketIndex == 0 || Integer.compareUnsigned(bucket.lowestDeliveryId, this.buckets[prevBucketIndex].highestDeliveryId) < 0 ? this.ALWAYS_FULL_BUCKET : this.buckets[prevBucketIndex];
            if (nextBucket.getFreeSpace() + prevBucket.getFreeSpace() >= bucket.entries) {
                int nextEntryOffset;
                int toCopyBackward = Math.min(prevBucket.getFreeSpace(), bucket.entries);
                if ((nextEntryOffset = ++bucketEntry - (bucket.readOffset + toCopyBackward)) < 0) {
                    result = (long)prevBucketIndex << 32;
                    result |= (long)(prevBucket.writeOffset + nextEntryOffset);
                } else if (nextBucket.entries + (bucket.entries - toCopyBackward) > 0) {
                    result = (long)bucketIndex << 32;
                    result |= (long)nextEntryOffset;
                }
                this.doCompaction(bucket, prevBucket, nextBucket);
                this.recycleBucket(bucketIndex);
            } else if (++bucketEntry < bucket.writeOffset) {
                result = (long)bucketIndex << 32;
                result |= (long)bucketEntry;
            } else if (nextBucketIndex <= this.current && this.buckets[nextBucketIndex].entries > 0) {
                result = (long)nextBucketIndex << 32;
                result |= (long)this.buckets[nextBucketIndex].readOffset;
            }
        } else {
            this.recycleBucket(bucketIndex);
            if (bucketIndex <= this.current && this.buckets[bucketIndex].entries > 0) {
                result = (long)bucketIndex << 32;
                result |= (long)this.buckets[bucketIndex].readOffset;
            }
        }
        return result;
    }

    private final void doCompaction(UnsettledBucket<Delivery> bucket, UnsettledBucket<Delivery> prev, UnsettledBucket<Delivery> next) {
        if (prev.getFreeSpace() > 0) {
            int toCopy = Math.min(bucket.entries, prev.getFreeSpace());
            if (prev.readOffset != 0) {
                System.arraycopy(prev.deliveries, prev.readOffset, prev.deliveries, 0, prev.entries);
                if (prev.writeOffset > prev.entries + toCopy) {
                    Arrays.fill(prev.deliveries, prev.entries, prev.writeOffset, null);
                }
                prev.writeOffset -= prev.readOffset;
                prev.readOffset = 0;
            }
            System.arraycopy(bucket.deliveries, bucket.readOffset, prev.deliveries, prev.writeOffset, toCopy);
            prev.entries += toCopy;
            prev.writeOffset = prev.entries;
            prev.highestDeliveryId = prev.entryIdAt(prev.writeOffset - 1);
            bucket.entries -= toCopy;
            bucket.writeOffset -= toCopy;
            bucket.readOffset += toCopy;
        }
        if (bucket.entries > 0) {
            if (next.readOffset != bucket.entries) {
                System.arraycopy(next.deliveries, next.readOffset, next.deliveries, bucket.entries, next.entries);
                if (next.readOffset < bucket.entries) {
                    Arrays.fill(next.deliveries, bucket.entries + next.entries, next.deliveries.length, null);
                }
            }
            System.arraycopy(bucket.deliveries, bucket.readOffset, next.deliveries, 0, bucket.entries);
            next.readOffset = 0;
            next.entries += bucket.entries;
            next.writeOffset = next.entries;
            next.lowestDeliveryId = next.entryIdAt(0);
            next.highestDeliveryId = next.entryIdAt(next.writeOffset - 1);
        }
    }

    private boolean tryCompact(int bucketIndex) {
        UnsettledBucket<Delivery> bucket = this.buckets[bucketIndex];
        int nextBucketIndex = bucketIndex + 1;
        int prevBucketIndex = bucketIndex - 1;
        if (bucket.isReadable()) {
            UnsettledBucket<Delivery> prevBucket;
            UnsettledBucket<Delivery> nextBucket = bucketIndex == this.current || Integer.compareUnsigned(bucket.highestDeliveryId, this.buckets[nextBucketIndex].lowestDeliveryId) > 0 ? this.ALWAYS_FULL_BUCKET : this.buckets[nextBucketIndex];
            UnsettledBucket<Delivery> unsettledBucket = prevBucket = bucketIndex == 0 || Integer.compareUnsigned(bucket.lowestDeliveryId, this.buckets[prevBucketIndex].highestDeliveryId) < 0 ? this.ALWAYS_FULL_BUCKET : this.buckets[prevBucketIndex];
            if (nextBucket.getFreeSpace() + prevBucket.getFreeSpace() >= bucket.entries) {
                this.doCompaction(bucket, prevBucket, nextBucket);
                return this.recycleBucket(bucketIndex);
            }
        } else {
            return this.recycleBucket(bucketIndex);
        }
        return false;
    }

    public static interface UnsettledGetDeliveryId<Delivery> {
        public int getDeliveryId(Delivery var1);
    }

    private static class UnsettledBucket<Delivery> {
        private int readOffset;
        private int writeOffset;
        private int entries;
        private int lowestDeliveryId = 0;
        private int highestDeliveryId = 0;
        private final Object[] deliveries;
        private final UnsettledGetDeliveryId<Delivery> deliveryIdSupplier;
        private static int BINARY_SEARCH_THRESHOLD = 64;

        private UnsettledBucket() {
            this.deliveryIdSupplier = null;
            this.deliveries = new Object[0];
            this.highestDeliveryId = UnsignedInteger.MAX_VALUE.intValue();
        }

        public UnsettledBucket(int bucketCapacity, UnsettledGetDeliveryId<Delivery> idSupplier) {
            this.deliveryIdSupplier = idSupplier;
            this.deliveries = new Object[bucketCapacity];
        }

        public boolean isReadable() {
            return this.entries > 0;
        }

        public int getFreeSpace() {
            return this.deliveries.length - this.entries;
        }

        public boolean isFull() {
            return this.writeOffset == this.deliveries.length;
        }

        public boolean isInRange(int deliveryId) {
            return Integer.compareUnsigned(deliveryId, this.lowestDeliveryId) >= 0 && Integer.compareUnsigned(deliveryId, this.highestDeliveryId) <= 0;
        }

        public boolean put(int deliveryId, Delivery delivery) {
            if (this.isFull() || Integer.compareUnsigned(deliveryId, this.highestDeliveryId) <= 0 && this.entries > 0) {
                return false;
            }
            if (this.entries == 0) {
                this.lowestDeliveryId = deliveryId;
            }
            this.highestDeliveryId = deliveryId;
            this.deliveries[this.writeOffset++] = delivery;
            ++this.entries;
            return true;
        }

        public Delivery get(int deliveryId) {
            Object delivery = this.deliveries[this.readOffset];
            if (this.deliveryIdSupplier.getDeliveryId(delivery) == deliveryId) {
                return (Delivery)delivery;
            }
            int location = this.search(deliveryId, this.readOffset + 1, this.writeOffset);
            if (location >= 0) {
                return (Delivery)this.deliveries[location];
            }
            return null;
        }

        public Delivery entryAt(int index) {
            return (Delivery)this.deliveries[index];
        }

        public int entryIdAt(int index) {
            return this.deliveryIdSupplier.getDeliveryId(this.deliveries[index]);
        }

        public Delivery remove(int deliveryId) {
            if (this.deliveryIdSupplier.getDeliveryId(this.deliveries[this.readOffset]) == deliveryId) {
                return this.removeAt(this.readOffset);
            }
            int location = this.search(deliveryId, this.readOffset + 1, this.writeOffset);
            if (location >= 0) {
                return this.removeAt(location);
            }
            return null;
        }

        public Delivery removeAt(int bucketEntry) {
            Object delivery = this.deliveries[bucketEntry];
            --this.entries;
            if (bucketEntry != this.readOffset) {
                System.arraycopy(this.deliveries, this.readOffset, this.deliveries, this.readOffset + 1, bucketEntry - this.readOffset);
                this.deliveries[this.readOffset++] = null;
                if (bucketEntry == this.writeOffset) {
                    this.highestDeliveryId = this.deliveryIdSupplier.getDeliveryId(this.deliveries[this.writeOffset - 1]);
                }
            } else {
                this.deliveries[this.readOffset++] = null;
                if (this.entries > 0) {
                    this.lowestDeliveryId = this.deliveryIdSupplier.getDeliveryId(this.deliveries[this.readOffset]);
                }
            }
            return (Delivery)delivery;
        }

        public void clear() {
            if (this.entries != 0) {
                Arrays.fill(this.deliveries, null);
                this.entries = 0;
            }
            this.lowestDeliveryId = UnsignedInteger.MAX_VALUE.intValue();
            this.highestDeliveryId = 0;
            this.writeOffset = 0;
            this.readOffset = 0;
        }

        public String toString() {
            return "UnsettledBucket { size=" + this.entries + " roff=" + this.readOffset + " woff=" + this.writeOffset + " lowID=" + this.lowestDeliveryId + " highID=" + this.highestDeliveryId + " }";
        }

        private int search(int deliveryId, int fromIndex, int toIndex) {
            if (toIndex - fromIndex < BINARY_SEARCH_THRESHOLD) {
                return this.linearSearch(deliveryId, fromIndex, toIndex);
            }
            return this.binarySearch(deliveryId, fromIndex, toIndex);
        }

        private int binarySearch(int deliveryId, int fromIndex, int toIndex) {
            int low = fromIndex;
            int high = toIndex - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int midDeliveryId = this.deliveryIdSupplier.getDeliveryId(this.deliveries[mid]);
                int cmp = UnsignedInteger.compare(midDeliveryId, deliveryId);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -1;
        }

        private int linearSearch(int deliveryId, int fromIndex, int toIndex) {
            for (int i = fromIndex; i < toIndex; ++i) {
                int idAtIndex = this.deliveryIdSupplier.getDeliveryId(this.deliveries[i]);
                int comp = UnsignedInteger.compare(idAtIndex, deliveryId);
                if (comp == 0) {
                    return i;
                }
                if (comp > 0) break;
            }
            return -1;
        }
    }

    private final class UnsettledTackingMapValues
    extends AbstractCollection<Delivery> {
        private UnsettledTackingMapValues() {
        }

        @Override
        public Iterator<Delivery> iterator() {
            return new UnsettledTrackingMapValuesIterator(0);
        }

        @Override
        public int size() {
            return UnsettledMap.this.totalEntries;
        }

        @Override
        public boolean contains(Object o) {
            return UnsettledMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object target) {
            int targetId = UnsettledMap.this.deliveryIdSupplier.getDeliveryId(target);
            return UnsettledMap.this.remove(targetId) != null;
        }

        @Override
        public void clear() {
            UnsettledMap.this.clear();
        }
    }

    private final class UnsettledTackingMapKeys
    extends AbstractSet<UnsignedInteger> {
        private UnsettledTackingMapKeys() {
        }

        @Override
        public Iterator<UnsignedInteger> iterator() {
            return new UnsettledTrackingMapKeysIterator(0);
        }

        @Override
        public int size() {
            return UnsettledMap.this.totalEntries;
        }

        @Override
        public boolean contains(Object o) {
            return UnsettledMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object target) {
            return UnsettledMap.this.remove(((Number)Number.class.cast(target)).intValue()) != null;
        }

        @Override
        public void clear() {
            UnsettledMap.this.clear();
        }
    }

    private final class UnsettledTackingMapEntries
    extends AbstractSet<Map.Entry<UnsignedInteger, Delivery>> {
        private UnsettledTackingMapEntries() {
        }

        @Override
        public Iterator<Map.Entry<UnsignedInteger, Delivery>> iterator() {
            return new UnsettledTrackingMapEntryIterator(0);
        }

        @Override
        public int size() {
            return UnsettledMap.this.totalEntries;
        }

        @Override
        public boolean contains(Object target) {
            if (target instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)target;
                return UnsettledMap.this.containsKey(entry.getKey());
            }
            return false;
        }

        @Override
        public boolean remove(Object target) {
            if (target instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)target;
                return UnsettledMap.this.remove(entry.getKey()) != null;
            }
            return false;
        }

        @Override
        public void clear() {
            UnsettledMap.this.clear();
        }
    }

    public static class ImmutableUnsettledTrackingkMapEntry<Delivery>
    implements Map.Entry<UnsignedInteger, Delivery> {
        private final int key;
        private final Delivery value;

        public ImmutableUnsettledTrackingkMapEntry(int key, Delivery value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public UnsignedInteger getKey() {
            return UnsignedInteger.valueOf(this.key);
        }

        public int getPrimitiveKey() {
            return this.key;
        }

        @Override
        public Delivery getValue() {
            return this.value;
        }

        @Override
        public Delivery setValue(Delivery value) {
            throw new UnsupportedOperationException();
        }
    }

    private final class UnsettledTrackingMapEntryIterator
    extends UnsettledTrackingMapIterator<Map.Entry<UnsignedInteger, Delivery>> {
        public UnsettledTrackingMapEntryIterator(int startAt) {
            super(startAt);
        }

        @Override
        protected Map.Entry<UnsignedInteger, Delivery> entryAt(int bucketIndex, int bucketEntry) {
            Object delivery = UnsettledMap.this.buckets[this.currentBucket].entryAt(bucketEntry);
            return new ImmutableUnsettledTrackingkMapEntry(UnsettledMap.this.deliveryIdSupplier.getDeliveryId(delivery), delivery);
        }
    }

    private final class UnsettledTrackingMapKeysIterator
    extends UnsettledTrackingMapIterator<UnsignedInteger> {
        public UnsettledTrackingMapKeysIterator(int startAt) {
            super(startAt);
        }

        @Override
        protected UnsignedInteger entryAt(int bucketIndex, int bucketEntry) {
            return UnsignedInteger.valueOf(UnsettledMap.this.deliveryIdSupplier.getDeliveryId(UnsettledMap.this.buckets[this.currentBucket].entryAt(bucketEntry)));
        }
    }

    private final class UnsettledTrackingMapValuesIterator
    extends UnsettledTrackingMapIterator<Delivery> {
        public UnsettledTrackingMapValuesIterator(int startAt) {
            super(startAt);
        }

        @Override
        protected Delivery entryAt(int bucketIndex, int bucketEntry) {
            return UnsettledMap.this.buckets[this.currentBucket].entryAt(bucketEntry);
        }
    }

    private abstract class UnsettledTrackingMapIterator<T>
    implements Iterator<T> {
        protected int currentBucket;
        protected int readOffset;
        protected T lastReturned;
        protected int lastReturnedbucket;
        protected int lastReturnedbucketIndex;
        protected int expectedModCount;

        public UnsettledTrackingMapIterator(int startAt) {
            this.currentBucket = UnsettledMap.this.buckets[startAt].isReadable() ? startAt : -1;
            this.readOffset = UnsettledMap.this.buckets[startAt].isReadable() ? UnsettledMap.this.buckets[startAt].readOffset : -1;
            this.expectedModCount = UnsettledMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.readOffset >= 0;
        }

        @Override
        public T next() {
            if (this.readOffset == -1) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != UnsettledMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedbucket = this.currentBucket;
            this.lastReturnedbucketIndex = this.readOffset;
            this.lastReturned = this.entryAt(this.currentBucket, this.readOffset);
            this.successor();
            return this.lastReturned;
        }

        protected abstract T entryAt(int var1, int var2);

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Cannot remove entry when next has not been called");
            }
            if (UnsettledMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            long next = UnsettledMap.this.removeAt(this.lastReturnedbucket, this.lastReturnedbucketIndex);
            if (next >= 0L) {
                this.currentBucket = (int)(next >> 32);
                this.readOffset = (int)(next & 0xFFFFFFFFFFFFFFFFL);
            } else {
                this.readOffset = -1;
            }
            this.expectedModCount = UnsettledMap.this.modCount;
            this.lastReturned = null;
        }

        private void successor() {
            if (++this.readOffset == UnsettledMap.this.buckets[this.currentBucket].writeOffset) {
                ++this.currentBucket;
                this.readOffset = this.currentBucket < UnsettledMap.this.buckets.length && UnsettledMap.this.buckets[this.currentBucket].isReadable() ? UnsettledMap.this.buckets[this.currentBucket].readOffset : -1;
            }
        }
    }
}

