/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.closure;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.Task;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.controller.impl.event.ControllerResult;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class ControllerClosure
implements Closure {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private final RemotingCommand requestEvent;
    private final CompletableFuture<RemotingCommand> future;
    private ControllerResult<?> controllerResult;
    private Task task;

    public ControllerClosure(RemotingCommand requestEvent) {
        this.requestEvent = requestEvent;
        this.future = new CompletableFuture();
        this.task = null;
    }

    public CompletableFuture<RemotingCommand> getFuture() {
        return this.future;
    }

    public void setControllerResult(ControllerResult<?> controllerResult) {
        this.controllerResult = controllerResult;
    }

    public void run(Status status) {
        if (status.isOk()) {
            RemotingCommand response = RemotingCommand.createResponseCommandWithHeader((int)this.controllerResult.getResponseCode(), (CommandCustomHeader)((CommandCustomHeader)this.controllerResult.getResponse()));
            if (this.controllerResult.getBody() != null) {
                response.setBody(this.controllerResult.getBody());
            }
            if (this.controllerResult.getRemark() != null) {
                response.setRemark(this.controllerResult.getRemark());
            }
            this.future.complete(response);
        } else {
            log.error("Failed to append to jRaft node, error is: {}.", (Object)status);
            this.future.complete(RemotingCommand.createResponseCommand((int)2015, (String)status.getErrorMsg()));
        }
    }

    public Task taskWithThisClosure() {
        if (this.task != null) {
            return this.task;
        }
        this.task = new Task();
        this.task.setDone((Closure)this);
        this.task.setData(this.requestEvent.encode());
        return this.task;
    }

    public RemotingCommand getRequestEvent() {
        return this.requestEvent;
    }
}

