/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

import ch.ethz.globis.phtree.PhTreeHelper;
import java.util.Arrays;
import java.util.Comparator;

public class PhEntry<T> {
    private long[] key;
    private T value;
    private Object subNode;

    public PhEntry(long[] key, T value) {
        this.key = key;
        this.value = value;
    }

    public PhEntry(PhEntry<T> e) {
        this.key = Arrays.copyOf(e.getKey(), e.getKey().length);
        this.value = e.getValue();
    }

    public long[] getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value == PhTreeHelper.NULL ? null : (T)this.value;
    }

    protected T getValueInternal() {
        return this.value;
    }

    protected void set(long[] key, T value) {
        this.key = key;
        this.value = value;
    }

    public void setKeyInternal(long[] key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhEntry)) {
            return false;
        }
        PhEntry pvEntry = (PhEntry)o;
        if (!Arrays.equals(this.key, pvEntry.key)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(pvEntry.value) : pvEntry.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? Arrays.hashCode(this.key) : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setValueInternal(T val) {
        this.value = val;
        this.subNode = null;
    }

    public void setNodeInternal(Object node) {
        this.value = null;
        this.subNode = node;
    }

    public String toString() {
        return Arrays.toString(this.key);
    }

    public Object getNodeInternal() {
        return this.subNode;
    }

    public boolean hasNodeInternal() {
        return this.subNode != null;
    }

    public static final class KeyComparator<T>
    implements Comparator<PhEntry<T>> {
        private final long[] val;

        public KeyComparator(long[] val) {
            this.val = val;
        }

        @Override
        public int compare(PhEntry<T> o1, PhEntry<T> o2) {
            double d = this.distSQ(((PhEntry)o1).key) - this.distSQ(((PhEntry)o2).key);
            return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
        }

        private final double distSQ(long[] v) {
            double d = 0.0;
            for (int i = 0; i < this.val.length; ++i) {
                double dl = v[i] - this.val[i];
                d += dl * dl;
            }
            return d;
        }
    }
}

