/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v16.bst;

import ch.ethz.globis.phtree.util.unsynced.LongArrayPool;
import ch.ethz.globis.phtree.util.unsynced.ObjectArrayPool;
import ch.ethz.globis.phtree.util.unsynced.ObjectPool;
import ch.ethz.globis.phtree.v16.Node;
import ch.ethz.globis.phtree.v16.PhTree16;
import ch.ethz.globis.phtree.v16.bst.BSTreePage;

public class BSTPool {
    private final ObjectArrayPool<Node.BSTEntry> entryArrayPool = ObjectArrayPool.create(Node.BSTEntry[]::new);
    private final LongArrayPool keyPool = LongArrayPool.create();
    private final ObjectArrayPool<BSTreePage> pageArrayPool = ObjectArrayPool.create(BSTreePage[]::new);
    private final ObjectPool<BSTreePage> pagePool = ObjectPool.create(null);
    private final ObjectPool<Node.BSTEntry> entryPool = ObjectPool.create(Node.BSTEntry::new);

    public static BSTPool create() {
        return new BSTPool();
    }

    private BSTPool() {
    }

    public Node.BSTEntry[] arrayCreateEntries(int newSize) {
        return this.entryArrayPool.getArray(newSize);
    }

    public Node.BSTEntry[] arrayExpand(Node.BSTEntry[] oldA, int newSize) {
        Node.BSTEntry[] newA = this.entryArrayPool.getArray(newSize);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        this.entryArrayPool.offer((Node.BSTEntry[])oldA);
        return newA;
    }

    public long[] arrayCreateLong(int newSize) {
        return this.keyPool.getArray(newSize);
    }

    public long[] arrayExpand(long[] oldA, int newSize) {
        long[] newA = this.keyPool.getArray(newSize);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        this.keyPool.offer(oldA);
        return newA;
    }

    public BSTreePage[] arrayCreateNodes(int newSize) {
        return this.pageArrayPool.getArray(newSize);
    }

    public BSTreePage[] arrayExpand(BSTreePage[] oldA, int newSize) {
        BSTreePage[] newA = this.pageArrayPool.getArray(newSize);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        this.pageArrayPool.offer((BSTreePage[])oldA);
        return newA;
    }

    public void reportFreeNode(BSTreePage p) {
        this.keyPool.offer(p.getKeys());
        if (p.isLeaf()) {
            p.updateNeighborsRemove();
            this.entryArrayPool.offer((Node.BSTEntry[])p.getValues());
        } else {
            this.pageArrayPool.offer((BSTreePage[])p.getSubPages());
        }
        p.nullify();
        this.pagePool.offer(p);
    }

    public BSTreePage getNode(Node ind, BSTreePage parent, boolean isLeaf, BSTreePage leftPredecessor, PhTree16<?> tree) {
        BSTreePage p = this.pagePool.get();
        if (p != null) {
            p.init(ind, parent, isLeaf, leftPredecessor);
            return p;
        }
        return new BSTreePage(ind, parent, isLeaf, leftPredecessor, tree);
    }

    public Node.BSTEntry getEntry() {
        return this.entryPool.get();
    }

    void offerEntry(Node.BSTEntry entry) {
        entry.set(0L, null, null);
        this.entryPool.offer(entry);
    }
}

