/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.authc;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HttpAuthenticationFilter
extends AuthenticatingFilter {
    private static final Logger log = LoggerFactory.getLogger(HttpAuthenticationFilter.class);
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    private String applicationName = "application";
    private String authcScheme;
    private String authzScheme;

    HttpAuthenticationFilter() {
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getAuthzScheme() {
        return this.authzScheme;
    }

    public void setAuthzScheme(String authzScheme) {
        this.authzScheme = authzScheme;
    }

    public String getAuthcScheme() {
        return this.authcScheme;
    }

    public void setAuthcScheme(String authcScheme) {
        this.authcScheme = authcScheme;
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        HttpServletRequest httpRequest = WebUtils.toHttp(request);
        String httpMethod = httpRequest.getMethod();
        Set<String> methods = this.httpMethodsFromOptions((String[])mappedValue);
        boolean authcRequired = methods.size() == 0;
        for (String m : methods) {
            if (!httpMethod.toUpperCase(Locale.ENGLISH).equals(m)) continue;
            authcRequired = true;
            break;
        }
        if (authcRequired) {
            return super.isAccessAllowed(request, response, mappedValue);
        }
        return true;
    }

    private Set<String> httpMethodsFromOptions(String[] options) {
        HashSet<String> methods = new HashSet<String>();
        if (options != null) {
            for (String option : options) {
                if (option.equalsIgnoreCase("permissive")) continue;
                methods.add(option.toUpperCase(Locale.ENGLISH));
            }
        }
        return methods;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        boolean loggedIn = false;
        if (this.isLoginAttempt(request, response)) {
            loggedIn = this.executeLogin(request, response);
        }
        if (!loggedIn) {
            this.sendChallenge(request, response);
        }
        return loggedIn;
    }

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        String authzHeader = this.getAuthzHeader(request);
        return authzHeader != null && this.isLoginAttempt(authzHeader);
    }

    @Override
    protected final boolean isLoginRequest(ServletRequest request, ServletResponse response) {
        return this.isLoginAttempt(request, response);
    }

    protected String getAuthzHeader(ServletRequest request) {
        HttpServletRequest httpRequest = WebUtils.toHttp(request);
        return httpRequest.getHeader(AUTHORIZATION_HEADER);
    }

    protected boolean isLoginAttempt(String authzHeader) {
        String authzScheme = this.getAuthzScheme().toLowerCase(Locale.ENGLISH);
        return authzHeader.toLowerCase(Locale.ENGLISH).startsWith(authzScheme);
    }

    protected boolean sendChallenge(ServletRequest request, ServletResponse response) {
        log.debug("Authentication required: sending 401 Authentication challenge response.");
        HttpServletResponse httpResponse = WebUtils.toHttp(response);
        httpResponse.setStatus(401);
        String authcHeader = this.getAuthcScheme() + " realm=\"" + this.getApplicationName() + "\"";
        httpResponse.setHeader(AUTHENTICATE_HEADER, authcHeader);
        return false;
    }

    @Override
    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String authorizationHeader = this.getAuthzHeader(request);
        if (authorizationHeader == null || authorizationHeader.length() == 0) {
            return this.createToken("", "", request, response);
        }
        log.debug("Attempting to execute login with auth header");
        String[] prinCred = this.getPrincipalsAndCredentials(authorizationHeader, request);
        if (prinCred == null || prinCred.length < 2) {
            String username = prinCred == null || prinCred.length == 0 ? "" : prinCred[0];
            return this.createToken(username, "", request, response);
        }
        String username = prinCred[0];
        String password = prinCred[1];
        return this.createToken(username, password, request, response);
    }

    protected String[] getPrincipalsAndCredentials(String authorizationHeader, ServletRequest request) {
        if (authorizationHeader == null) {
            return null;
        }
        String[] authTokens = authorizationHeader.split(" ");
        if (authTokens == null || authTokens.length < 2) {
            return null;
        }
        return this.getPrincipalsAndCredentials(authTokens[0], authTokens[1]);
    }

    abstract String[] getPrincipalsAndCredentials(String var1, String var2);
}

