/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http.refresh;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.sync.data.http.refresh.DataRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataRefresh<T>
implements DataRefresh {
    protected static final ConcurrentMap<ConfigGroupEnum, ConfigData<?>> GROUP_CACHE = new ConcurrentHashMap();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataRefresh.class);

    protected abstract JsonObject convert(JsonObject var1);

    protected abstract ConfigData<T> fromJson(JsonObject var1);

    protected abstract void refresh(List<T> var1);

    @Override
    public Boolean refresh(JsonObject data) {
        JsonObject jsonObject = this.convert(data);
        if (Objects.isNull(jsonObject)) {
            return false;
        }
        boolean updated = false;
        ConfigData<T> result = this.fromJson(jsonObject);
        if (this.updateCacheIfNeed(result)) {
            updated = true;
            this.refresh(result.getData());
        }
        return updated;
    }

    protected abstract boolean updateCacheIfNeed(ConfigData<T> var1);

    protected boolean updateCacheIfNeed(ConfigData<T> newVal, ConfigGroupEnum groupEnum) {
        if (Objects.isNull(GROUP_CACHE.putIfAbsent(groupEnum, newVal))) {
            return true;
        }
        ResultHolder holder = new ResultHolder(false);
        GROUP_CACHE.merge(groupEnum, newVal, (oldVal, value) -> {
            if (StringUtils.equals((CharSequence)oldVal.getMd5(), (CharSequence)newVal.getMd5())) {
                LOG.info("Get the same config, the [{}] config cache will not be updated, md5:{}", (Object)groupEnum, (Object)oldVal.getMd5());
                return oldVal;
            }
            if (oldVal.getLastModifyTime() >= newVal.getLastModifyTime()) {
                LOG.info("Last update time earlier than the current configuration, the [{}] config cache will not be updated", (Object)groupEnum);
                return oldVal;
            }
            LOG.info("update {} config: {}", (Object)groupEnum, (Object)newVal);
            holder.result = true;
            return newVal;
        });
        return holder.result;
    }

    private static final class ResultHolder {
        private boolean result;

        ResultHolder(boolean result) {
            this.result = result;
        }
    }
}

