/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.base.handler.MetaDataHandler;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonMetaDataSubscriber
implements MetaDataSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(CommonMetaDataSubscriber.class);
    private final Map<String, MetaDataHandler> handlerMap;

    public CommonMetaDataSubscriber(List<MetaDataHandler> metaDataHandlerList) {
        this.handlerMap = metaDataHandlerList.stream().collect(Collectors.toConcurrentMap(MetaDataHandler::rpcType, e -> e));
    }

    public void onSubscribe(MetaData metaData) {
        Optional.ofNullable(this.handlerMap.get(metaData.getRpcType())).ifPresent(handler -> {
            LOG.info("subscribe metaData: {}", (Object)JsonUtils.toJson((Object)metaData));
            handler.handle(metaData);
        });
    }

    public void unSubscribe(MetaData metaData) {
        Optional.ofNullable(this.handlerMap.get(metaData.getRpcType())).ifPresent(handler -> {
            LOG.info("unSubscribe metaData: {}", (Object)JsonUtils.toJson((Object)metaData));
            handler.remove(metaData);
        });
    }

    public void refresh() {
        if (MapUtils.isEmpty(this.handlerMap)) {
            return;
        }
        LOG.info("start refresh metadata");
        this.handlerMap.forEach((k, v) -> v.refresh());
    }
}

