/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.core.nio;

import com.qq.tars.net.core.Session;
import com.qq.tars.net.core.nio.Acceptor;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.core.nio.UDPSession;
import java.io.IOException;
import java.nio.channels.SelectionKey;

public class UDPAcceptor
extends Acceptor {
    private int bufferSize;

    public UDPAcceptor(SelectorManager selectorManager) {
        super(selectorManager);
        String s = System.getProperty("com.qq.nami.server.udp.bufferSize", "4096");
        try {
            this.bufferSize = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.bufferSize = 4096;
        }
    }

    @Override
    public void handleConnectEvent(SelectionKey key) throws IOException {
        throw new IllegalStateException("UDP can't handle OP_CONNECT event");
    }

    @Override
    public void handleAcceptEvent(SelectionKey key) throws IOException {
        throw new IllegalStateException("UDP can't handle OP_ACCEPT event");
    }

    @Override
    public void handleReadEvent(SelectionKey key) throws IOException {
        UDPSession session = null;
        if (key.attachment() == null) {
            session = new UDPSession(this.selectorManager);
            session.setBufferSize(this.bufferSize);
            session.setChannel(key.channel());
            session.setStatus(Session.SessionStatus.SERVER_CONNECTED);
        } else {
            session = (UDPSession)key.attachment();
        }
        session.read();
    }

    @Override
    public void handleWriteEvent(SelectionKey key) throws IOException {
    }
}

