/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MultiplexerTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final List<String> filters;
    @Nullable
    private final Boolean preserveOriginal;
    public static final JsonpDeserializer<MultiplexerTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiplexerTokenFilter::setupMultiplexerTokenFilterDeserializer);

    private MultiplexerTokenFilter(Builder builder) {
        super(builder);
        this.filters = ApiTypeHelper.unmodifiableRequired(builder.filters, (Object)this, "filters");
        this.preserveOriginal = builder.preserveOriginal;
    }

    public static MultiplexerTokenFilter of(Function<Builder, ObjectBuilder<MultiplexerTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Multiplexer;
    }

    public final List<String> filters() {
        return this.filters;
    }

    @Nullable
    public final Boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "multiplexer");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.filters)) {
            generator.writeKey("filters");
            generator.writeStartArray();
            for (String item0 : this.filters) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.preserveOriginal != null) {
            generator.writeKey("preserve_original");
            generator.write(this.preserveOriginal.booleanValue());
        }
    }

    protected static void setupMultiplexerTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::filters, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filters");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MultiplexerTokenFilter> {
        private List<String> filters;
        @Nullable
        private Boolean preserveOriginal;

        public final Builder filters(List<String> list) {
            this.filters = Builder._listAddAll(this.filters, list);
            return this;
        }

        public final Builder filters(String value, String ... values) {
            this.filters = Builder._listAdd(this.filters, value, values);
            return this;
        }

        public final Builder preserveOriginal(@Nullable Boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiplexerTokenFilter build() {
            this._checkSingleUse();
            return new MultiplexerTokenFilter(this);
        }
    }
}

