/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class RepositorySettingsBase
implements JsonpSerializable {
    @Nullable
    private final String chunkSize;
    @Nullable
    private final Boolean compress;
    @Nullable
    private final String maxRestoreBytesPerSec;
    @Nullable
    private final String maxSnapshotBytesPerSec;

    protected RepositorySettingsBase(AbstractBuilder<?> builder) {
        this.chunkSize = ((AbstractBuilder)builder).chunkSize;
        this.compress = ((AbstractBuilder)builder).compress;
        this.maxRestoreBytesPerSec = ((AbstractBuilder)builder).maxRestoreBytesPerSec;
        this.maxSnapshotBytesPerSec = ((AbstractBuilder)builder).maxSnapshotBytesPerSec;
    }

    @Nullable
    public final String chunkSize() {
        return this.chunkSize;
    }

    @Nullable
    public final Boolean compress() {
        return this.compress;
    }

    @Nullable
    public final String maxRestoreBytesPerSec() {
        return this.maxRestoreBytesPerSec;
    }

    @Nullable
    public final String maxSnapshotBytesPerSec() {
        return this.maxSnapshotBytesPerSec;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkSize != null) {
            generator.writeKey("chunk_size");
            generator.write(this.chunkSize);
        }
        if (this.compress != null) {
            generator.writeKey("compress");
            generator.write(this.compress.booleanValue());
        }
        if (this.maxRestoreBytesPerSec != null) {
            generator.writeKey("max_restore_bytes_per_sec");
            generator.write(this.maxRestoreBytesPerSec);
        }
        if (this.maxSnapshotBytesPerSec != null) {
            generator.writeKey("max_snapshot_bytes_per_sec");
            generator.write(this.maxSnapshotBytesPerSec);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupRepositorySettingsBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::chunkSize, JsonpDeserializer.stringDeserializer(), "chunk_size");
        op.add(AbstractBuilder::compress, JsonpDeserializer.booleanDeserializer(), "compress");
        op.add(AbstractBuilder::maxRestoreBytesPerSec, JsonpDeserializer.stringDeserializer(), "max_restore_bytes_per_sec");
        op.add(AbstractBuilder::maxSnapshotBytesPerSec, JsonpDeserializer.stringDeserializer(), "max_snapshot_bytes_per_sec");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private String chunkSize;
        @Nullable
        private Boolean compress;
        @Nullable
        private String maxRestoreBytesPerSec;
        @Nullable
        private String maxSnapshotBytesPerSec;

        public final BuilderT chunkSize(@Nullable String value) {
            this.chunkSize = value;
            return (BuilderT)this.self();
        }

        public final BuilderT compress(@Nullable Boolean value) {
            this.compress = value;
            return (BuilderT)this.self();
        }

        public final BuilderT maxRestoreBytesPerSec(@Nullable String value) {
            this.maxRestoreBytesPerSec = value;
            return (BuilderT)this.self();
        }

        public final BuilderT maxSnapshotBytesPerSec(@Nullable String value) {
            this.maxSnapshotBytesPerSec = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

