/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.Repository;
import co.elastic.clients.elasticsearch.snapshot.RepositoryBase;
import co.elastic.clients.elasticsearch.snapshot.RepositoryVariant;
import co.elastic.clients.elasticsearch.snapshot.SharedFileSystemRepositorySettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SharedFileSystemRepository
extends RepositoryBase
implements RepositoryVariant {
    private final SharedFileSystemRepositorySettings settings;
    public static final JsonpDeserializer<SharedFileSystemRepository> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SharedFileSystemRepository::setupSharedFileSystemRepositoryDeserializer);

    private SharedFileSystemRepository(Builder builder) {
        super(builder);
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
    }

    public static SharedFileSystemRepository of(Function<Builder, ObjectBuilder<SharedFileSystemRepository>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Repository.Kind _repositoryKind() {
        return Repository.Kind.Fs;
    }

    public final SharedFileSystemRepositorySettings settings() {
        return this.settings;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "fs");
        super.serializeInternal(generator, mapper);
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
    }

    protected static void setupSharedFileSystemRepositoryDeserializer(ObjectDeserializer<Builder> op) {
        RepositoryBase.setupRepositoryBaseDeserializer(op);
        op.add(Builder::settings, SharedFileSystemRepositorySettings._DESERIALIZER, "settings");
        op.ignore("type");
    }

    public static class Builder
    extends RepositoryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SharedFileSystemRepository> {
        private SharedFileSystemRepositorySettings settings;

        public final Builder settings(SharedFileSystemRepositorySettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<SharedFileSystemRepositorySettings.Builder, ObjectBuilder<SharedFileSystemRepositorySettings>> fn) {
            return this.settings(fn.apply(new SharedFileSystemRepositorySettings.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SharedFileSystemRepository build() {
            this._checkSingleUse();
            return new SharedFileSystemRepository(this);
        }
    }
}

