/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ratelimiter.resolver;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.plugin.ratelimiter.resolver.RateLimiterKeyResolver;
import org.apache.shenyu.spi.Join;
import org.springframework.web.server.ServerWebExchange;

@Join
public class RemoteAddrKeyResolver
implements RateLimiterKeyResolver {
    private static final String[] HEADERS = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
    private static final String UNKNOWN = "unknown";

    @Override
    public String getKeyResolverName() {
        return "REMOTE_ADDRESS_KEY_RESOLVER";
    }

    @Override
    public String resolve(ServerWebExchange exchange) {
        for (String header : HEADERS) {
            boolean isUnknown;
            String ip = exchange.getRequest().getHeaders().getFirst(header);
            boolean bl = isUnknown = StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip);
            if (isUnknown) continue;
            if (StringUtils.indexOf((CharSequence)ip, (int)44) > 0) {
                String[] split = StringUtils.split((String)ip, (char)',');
                for (int i = 0; i < split.length; ++i) {
                    split[i] = split[i].trim();
                }
                for (String subIp : split) {
                    boolean isUnknownSubIp;
                    boolean bl2 = isUnknownSubIp = StringUtils.isBlank((CharSequence)subIp) || UNKNOWN.equalsIgnoreCase(subIp);
                    if (isUnknownSubIp) continue;
                    ip = subIp;
                    break;
                }
            }
            return ip;
        }
        return Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress();
    }
}

