/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.sofa.rpc.context.BaggageResolver;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;

@Extension(value="providerBaggage", order=-11000)
@AutoActive(providerSide=true)
public class ProviderBaggageFilter
extends Filter {
    @Override
    public boolean needToLoad(FilterInvoker invoker) {
        return RpcInvokeContext.isBaggageEnable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        SofaResponse response = null;
        try {
            BaggageResolver.pickupFromRequest(RpcInvokeContext.peekContext(), request, true);
            response = invoker.invoke(request);
            if (response == null) return response;
        }
        catch (Throwable throwable) {
            if (response == null) throw throwable;
            BaggageResolver.carryWithResponse(RpcInvokeContext.peekContext(), response);
            throw throwable;
        }
        BaggageResolver.carryWithResponse(RpcInvokeContext.peekContext(), response);
        return response;
    }
}

