/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal.shared;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.LocalizedException;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.InternationalString;

public final class LocalizedParseException
extends ParseException
implements LocalizedException {
    private static final long serialVersionUID = -1467571540435486742L;
    private final transient short key;
    private final transient Object[] parameters;

    public LocalizedParseException(Locale locale, short key, Object[] parameters, int errorOffset) {
        super(Errors.forLocale(locale).getString(key, parameters), errorOffset);
        this.parameters = parameters;
        this.key = key;
    }

    public LocalizedParseException(Locale locale, Class<?> type, CharSequence text, ParsePosition pos) {
        this(locale, type, text, pos != null ? pos.getIndex() : 0, pos != null ? pos.getErrorIndex() : 0);
    }

    private LocalizedParseException(Locale locale, Class<?> type, CharSequence text, int offset, int errorOffset) {
        this(locale, LocalizedParseException.parameters(type, text, offset, Math.max(offset, errorOffset)), errorOffset);
    }

    private LocalizedParseException(Locale locale, Object[] parameters, int errorOffset) {
        this(locale, LocalizedParseException.key(parameters), parameters, errorOffset);
    }

    private static Object[] parameters(Class<?> type, CharSequence text, int offset, int errorOffset) {
        if (errorOffset >= text.length()) {
            return new Object[]{text};
        }
        CharSequence erroneous = CharSequences.token(text, errorOffset);
        text = text.subSequence(offset, text.length());
        if (erroneous.length() == 0) {
            return new Object[]{type, text};
        }
        return new Object[]{type, text, erroneous};
    }

    private static short key(Object[] parameters) {
        short key;
        switch (parameters.length) {
            case 1: {
                key = 169;
                break;
            }
            case 2: {
                key = 186;
                break;
            }
            case 3: {
                key = 187;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return key;
    }

    @Override
    public String getMessage() {
        return this.key != 0 ? Errors.format(this.key, this.parameters) : super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return super.getMessage();
    }

    @Override
    public InternationalString getInternationalMessage() {
        return this.key != 0 ? Errors.formatInternational(this.key, this.parameters) : null;
    }

    @Override
    public LocalizedParseException initCause(Throwable cause) {
        return (LocalizedParseException)super.initCause(cause);
    }
}

