/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.pending.geoapi.referencing;

import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.FactoryException;

public final class MissingMethods {
    public static volatile Function<CoordinateReferenceSystem, DefaultDatumEnsemble<?>> datumEnsemble;
    public static volatile Function<GeodeticCRS, DefaultDatumEnsemble<GeodeticDatum>> geodeticDatumEnsemble;

    private MissingMethods() {
    }

    public static DefaultDatumEnsemble<?> getDatumEnsemble(CoordinateReferenceSystem crs) {
        Function<CoordinateReferenceSystem, DefaultDatumEnsemble<?>> m = datumEnsemble;
        return m != null ? m.apply(crs) : null;
    }

    public static DefaultDatumEnsemble<GeodeticDatum> getDatumEnsemble(GeodeticCRS crs) {
        Function<GeodeticCRS, DefaultDatumEnsemble<GeodeticDatum>> m = geodeticDatumEnsemble;
        return m != null ? m.apply(crs) : null;
    }

    public static DefaultDatumEnsemble<VerticalDatum> getDatumEnsemble(VerticalCRS crs) {
        return crs instanceof DefaultVerticalCRS ? ((DefaultVerticalCRS)crs).getDatumEnsemble() : null;
    }

    public static DefaultDatumEnsemble<TemporalDatum> getDatumEnsemble(TemporalCRS crs) {
        return crs instanceof DefaultTemporalCRS ? ((DefaultTemporalCRS)crs).getDatumEnsemble() : null;
    }

    public static DefaultDatumEnsemble<EngineeringDatum> getDatumEnsemble(EngineeringCRS crs) {
        return crs instanceof DefaultEngineeringCRS ? ((DefaultEngineeringCRS)crs).getDatumEnsemble() : null;
    }

    public static <D extends Datum> DefaultDatumEnsemble<D> createDatumEnsemble(Map<String, ?> properties, Collection<? extends D> members, PositionalAccuracy accuracy, DatumFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createDatumEnsemble(properties, members, accuracy);
    }

    public static DefaultParametricCS createParametricCS(Map<String, ?> properties, CoordinateSystemAxis axis, CSFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createParametricCS(properties, axis);
    }

    public static DefaultParametricCRS createParametricCRS(Map<String, ?> properties, DefaultParametricDatum datum, DefaultParametricCS cs, CRSFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createParametricCRS(properties, datum, cs);
    }

    public static DefaultParametricDatum createParametricDatum(Map<String, ?> properties, DatumFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createParametricDatum(properties);
    }

    public static VerticalDatum createVerticalDatum(Map<String, ?> properties, VerticalDatumType type, Temporal epoch, DatumFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createVerticalDatum(properties, type, epoch);
    }

    public static GeodeticDatum createGeodeticDatum(Map<String, ?> properties, Ellipsoid ellipsoid, PrimeMeridian primeMeridian, Temporal epoch, DatumFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createGeodeticDatum(properties, ellipsoid, primeMeridian, epoch);
    }

    public static GeographicCRS createGeographicCRS(Map<String, ?> properties, GeodeticDatum datum, DefaultDatumEnsemble<GeodeticDatum> ensemble, EllipsoidalCS cs, CRSFactory factory) throws FactoryException {
        if (ensemble == null) {
            return factory.createGeographicCRS(properties, datum, cs);
        }
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createGeographicCRS(properties, datum, ensemble, cs);
    }

    public static GeodeticCRS createGeodeticCRS(Map<String, ?> properties, GeodeticDatum datum, DefaultDatumEnsemble<GeodeticDatum> ensemble, SphericalCS cs, CRSFactory factory) throws FactoryException {
        if (ensemble == null) {
            return factory.createGeocentricCRS(properties, datum, cs);
        }
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createGeodeticCRS(properties, datum, ensemble, cs);
    }

    public static GeodeticCRS createGeodeticCRS(Map<String, ?> properties, GeodeticDatum datum, DefaultDatumEnsemble<GeodeticDatum> ensemble, CartesianCS cs, CRSFactory factory) throws FactoryException {
        if (ensemble == null) {
            return factory.createGeocentricCRS(properties, datum, cs);
        }
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createGeodeticCRS(properties, datum, ensemble, cs);
    }

    public static VerticalCRS createVerticalCRS(Map<String, ?> properties, VerticalDatum datum, DefaultDatumEnsemble<VerticalDatum> ensemble, VerticalCS cs, CRSFactory factory) throws FactoryException {
        if (ensemble == null) {
            return factory.createVerticalCRS(properties, datum, cs);
        }
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createVerticalCRS(properties, datum, ensemble, cs);
    }

    public static TemporalCRS createTemporalCRS(Map<String, ?> properties, TemporalDatum datum, DefaultDatumEnsemble<TemporalDatum> ensemble, TimeCS cs, CRSFactory factory) throws FactoryException {
        if (ensemble == null) {
            return factory.createTemporalCRS(properties, datum, cs);
        }
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createTemporalCRS(properties, datum, ensemble, cs);
    }

    public static DefaultParametricCRS createParametricCRS(Map<String, ?> properties, DefaultParametricDatum datum, DefaultDatumEnsemble<DefaultParametricDatum> ensemble, DefaultParametricCS cs, CRSFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createParametricCRS(properties, datum, ensemble, cs);
    }

    public static EngineeringCRS createEngineeringCRS(Map<String, ?> properties, EngineeringDatum datum, DefaultDatumEnsemble<EngineeringDatum> ensemble, CoordinateSystem cs, CRSFactory factory) throws FactoryException {
        if (ensemble == null) {
            return factory.createEngineeringCRS(properties, datum, cs);
        }
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createEngineeringCRS(properties, datum, ensemble, cs);
    }
}

