/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.xml.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.Locale;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.storage.xml.stream.StaxDataStore;
import org.apache.sis.storage.xml.stream.StaxStreamWriter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;

public abstract class RewriteOnUpdate
implements AutoCloseable {
    protected final FeatureSet source;
    private final Path location;
    private boolean isSourceEmpty;
    private Stream<? extends AbstractFeature> filtered;

    public RewriteOnUpdate(FeatureSet source, Path location) throws IOException {
        this.source = source;
        this.location = location;
        this.isSourceEmpty = location == null || Files.notExists(location, new LinkOption[0]) || Files.size(location) == 0L;
    }

    protected final Locale getLocale() {
        return this.source instanceof StaxDataStore ? ((StaxDataStore)this.source).getDataLocale() : null;
    }

    private boolean isEmpty() throws ReadOnlyStorageException {
        if (this.isSourceEmpty) {
            return this.filtered == null;
        }
        if (this.location != null) {
            return false;
        }
        throw new ReadOnlyStorageException();
    }

    private Stream<? extends AbstractFeature> filtered() throws DataStoreException {
        if (this.filtered == null) {
            this.filtered = this.features();
        }
        return this.filtered;
    }

    protected Stream<? extends AbstractFeature> features() throws DataStoreException {
        return this.source.features(false);
    }

    public void add(Iterator<? extends AbstractFeature> features) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"features", features);
        Stream<? extends AbstractFeature> toAdd = StreamSupport.stream(Spliterators.spliteratorUnknownSize(features, 16), false);
        this.filtered = this.isEmpty() ? toAdd : Stream.concat(this.filtered(), toAdd);
    }

    public void removeIf(Predicate<? super AbstractFeature> filter) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"filter", filter);
        if (!this.isEmpty()) {
            this.filtered = this.filtered().filter(feature -> !filter.test((AbstractFeature)feature));
        }
    }

    public void replaceIf(Predicate<? super AbstractFeature> filter, UnaryOperator<AbstractFeature> updater) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"filter", filter);
        ArgumentChecks.ensureNonNull((String)"updater", updater);
        if (!this.isEmpty()) {
            this.filtered = this.filtered().map(feature -> feature != null && filter.test((AbstractFeature)feature) ? (AbstractFeature)updater.apply((AbstractFeature)feature) : feature);
        }
    }

    protected abstract Path createTemporaryFile() throws IOException;

    protected abstract StaxStreamWriter createWriter(OutputStream var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws DataStoreException {
        block25: {
            try (Stream<? extends AbstractFeature> content = this.filtered;){
                if (content == null) break block25;
                this.filtered = null;
                OutputStream temporary = null;
                Path target = this.isSourceEmpty ? null : this.createTemporaryFile();
                try {
                    if (target != null) {
                        temporary = Files.newOutputStream(target, new OpenOption[0]);
                    }
                    try (StaxStreamWriter writer = this.createWriter(temporary);){
                        temporary = null;
                        this.isSourceEmpty = false;
                        writer.writeStartDocument();
                        ((Stream)content.sequential()).forEachOrdered(writer);
                        writer.writeEndDocument();
                    }
                    if (target != null) {
                        Files.move(target, this.location, StandardCopyOption.REPLACE_EXISTING);
                        target = null;
                    }
                }
                finally {
                    if (temporary != null) {
                        temporary.close();
                    }
                    if (target != null) {
                        Files.delete(target);
                    }
                }
            }
            catch (DataStoreException e) {
                throw e;
            }
            catch (BackingStoreException e) {
                Throwable cause = e.getCause();
                if (cause instanceof DataStoreException) {
                    throw (DataStoreException)cause;
                }
                throw new DataStoreException(e.getLocalizedMessage(), cause);
            }
            catch (Exception e2) {
                IOException e2;
                if (e2 instanceof UncheckedIOException) {
                    e2 = ((UncheckedIOException)e2).getCause();
                }
                throw new DataStoreException((Throwable)e2);
            }
        }
    }

    @Override
    public void close() {
        Stream<? extends AbstractFeature> content = this.filtered;
        if (content != null) {
            this.filtered = null;
            content.close();
        }
    }
}

