/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LessThan$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 1 _FUNC_ 2;\n       true\n      > SELECT 1.1 _FUNC_ '1';\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u00151\u0006\u0001\"\u0015X\u0011\u0015y\u0006\u0001\"\u0015a\u0011\u001d)\u0007!!A\u0005\u0002\u0019Dq!\u001b\u0001\u0012\u0002\u0013\u0005!\u000eC\u0004v\u0001E\u0005I\u0011\u00016\t\u000fY\u0004\u0011\u0011!C!o\"Aq\u0010AA\u0001\n\u0003\t\t\u0001C\u0005\u0002\n\u0001\t\t\u0011\"\u0001\u0002\f!I\u0011\u0011\u0003\u0001\u0002\u0002\u0013\u0005\u00131\u0003\u0005\n\u0003C\u0001\u0011\u0011!C\u0001\u0003GA\u0011\"!\f\u0001\u0003\u0003%\t%a\f\b\u0013\u0005e#$!A\t\u0002\u0005mc\u0001C\r\u001b\u0003\u0003E\t!!\u0018\t\r\u0011\u001bB\u0011AA6\u0011%\tigEA\u0001\n\u000b\ny\u0007C\u0005\u0002rM\t\t\u0011\"!\u0002t!I\u0011\u0011P\n\u0002\u0002\u0013\u0005\u00151\u0010\u0005\n\u0003\u001b\u001b\u0012\u0011!C\u0005\u0003\u001f\u0013\u0001\u0002T3tgRC\u0017M\u001c\u0006\u00037q\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QDH\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u000b\u00174sA\u0011\u0011FK\u0007\u00025%\u00111F\u0007\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"!\f\u0019\u000f\u0005%r\u0013BA\u0018\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!!\r\u001a\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011qF\u0007\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\b!J|G-^2u!\t!$(\u0003\u0002<k\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005q\u0004CA\u0015@\u0013\t\u0001%D\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002G\u000f\"\u0003\"!\u000b\u0001\t\u000bq*\u0001\u0019\u0001 \t\u000b\t+\u0001\u0019\u0001 \u0002\rMLXNY8m+\u0005Y\u0005C\u0001'T\u001d\ti\u0015\u000b\u0005\u0002Ok5\tqJ\u0003\u0002QM\u00051AH]8pizJ!AU\u001b\u0002\rA\u0013X\rZ3g\u0013\t!VK\u0001\u0004TiJLgn\u001a\u0006\u0003%V\nAB\\;mYN\u000bg-Z#wC2$2\u0001W.^!\t!\u0014,\u0003\u0002[k\t\u0019\u0011I\\=\t\u000bq;\u0001\u0019\u0001-\u0002\r%t\u0007/\u001e;2\u0011\u0015qv\u00011\u0001Y\u0003\u0019Ig\u000e];ue\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004}\u0005\u001c\u0007\"\u00022\t\u0001\u0004q\u0014a\u00028fo2+g\r\u001e\u0005\u0006I\"\u0001\rAP\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\r1u\r\u001b\u0005\by%\u0001\n\u00111\u0001?\u0011\u001d\u0011\u0015\u0002%AA\u0002y\nabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001lU\tqDnK\u0001n!\tq7/D\u0001p\u0015\t\u0001\u0018/A\u0005v]\u000eDWmY6fI*\u0011!/N\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001;p\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t\u0001\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006!A.\u00198h\u0015\u0005i\u0018\u0001\u00026bm\u0006L!\u0001\u0016>\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\r\u0001c\u0001\u001b\u0002\u0006%\u0019\u0011qA\u001b\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007a\u000bi\u0001C\u0005\u0002\u00109\t\t\u00111\u0001\u0002\u0004\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0006\u0011\u000b\u0005]\u0011Q\u0004-\u000e\u0005\u0005e!bAA\u000ek\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0011\u0011\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002&\u0005-\u0002c\u0001\u001b\u0002(%\u0019\u0011\u0011F\u001b\u0003\u000f\t{w\u000e\\3b]\"A\u0011q\u0002\t\u0002\u0002\u0003\u0007\u0001,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003K\t\t\u0004\u0003\u0005\u0002\u0010E\t\t\u00111\u0001YQ]\u0001\u0011QGA\u001e\u0003{\t\t%a\u0011\u0002H\u0005%\u0013QJA(\u0003'\n)\u0006E\u0002*\u0003oI1!!\u000f\u001b\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u0010\u0002\u0005\u0016D\bO]\u0019!?\u001a+fjQ0!Kb\u0004(O\r\u0011.AI+G/\u001e:og\u0002\"(/^3!S\u001a\u0004\u0003-\u001a=qeF\u0002\u0007%[:!Y\u0016\u001c8\u000f\t;iC:\u0004\u0003-\u001a=qeJ\u0002g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011QI\u0001\u0003\u0014*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qeFb\u0003%\u001a=qeJ\u0002S\u0006\t;iK\u0002\"xo\u001c\u0011fqB\u0014Xm]:j_:\u001c\b%\\;ti\u0002\u0012W\rI:b[\u0016\u0004C/\u001f9fA=\u0014\beY1oA\t,\u0007eY1ti\u0016$\u0007\u0005^8!C\u0002\u001aw.\\7p]\u0002\"\u0018\u0010]3-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00198eA5,8\u000f\u001e\u0011cK\u0002\n\u0007\u0005^=qK\u0002\"\b.\u0019;!G\u0006t\u0007EY3!_J$WM]3e]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-A5\f\u0007\u000f\t;za\u0016\u0004\u0013n\u001d\u0011o_R\u0004sN\u001d3fe\u0006\u0014G.\u001a\u0017!g>\u0004\u0013\u000e\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001J7\u000f\t8pi\u0002\u001aX\u000f\u001d9peR,GM\f\u0011G_J\u00043m\\7qY\u0016D\b\u0005^=qKN\u00043/^2iA\u0005\u0014(/Y=0gR\u0014Xo\u0019;-AQDW\r\t3bi\u0006\u0004C/\u001f9fg\u0002zg\r\t4jK2$7\u000fI7vgRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011cK\u0002z'\u000fZ3sC\ndWM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002L\u0005\u0011\u0019K\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112A}3UKT\"`AIZ$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0013GL\u0019!?\u001a+fjQ0!OE:3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t4bYN,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;p?\u0012\fG/\u001a\u0015(eA\u0002\u0014(\f\u00198[M\u0002\u0004\u0005\r\u001b;c]RTGM\u0014*A}3UKT\"`AQ|w\fZ1uK\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t4bYN,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;p?\u0012\fG/\u001a\u0015(eA\u0002\u0014(\f\u00198[M\u0002\u0004\u0005\r\u001b;c]RTGM\u0014*A}3UKT\"`AQ|w\fZ1uK\":#\u0007\r\u0019:[ABT\u0006M\u0019!aQR\u0014g\u000e\u001e6e\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\r\u0011`\rVs5i\u0018\u0011O+2c5H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003#\nQ!\r\u00181]A\nQa\u001a:pkB\f#!a\u0016\u0002\u001fA\u0014X\rZ5dCR,wLZ;oGN\f\u0001\u0002T3tgRC\u0017M\u001c\t\u0003SM\u0019BaEA0sA9\u0011\u0011MA4}y2UBAA2\u0015\r\t)'N\u0001\beVtG/[7f\u0013\u0011\tI'a\u0019\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002\\\u0005AAo\\*ue&tw\rF\u0001y\u0003\u0015\t\u0007\u000f\u001d7z)\u00151\u0015QOA<\u0011\u0015ad\u00031\u0001?\u0011\u0015\u0011e\u00031\u0001?\u0003\u001d)h.\u00199qYf$B!! \u0002\nB)A'a \u0002\u0004&\u0019\u0011\u0011Q\u001b\u0003\r=\u0003H/[8o!\u0015!\u0014Q\u0011 ?\u0013\r\t9)\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005-u#!AA\u0002\u0019\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\u0005cA=\u0002\u0014&\u0019\u0011Q\u0013>\u0003\r=\u0013'.Z2u\u0001")
public class LessThan
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThan lessThan) {
        return LessThan$.MODULE$.unapply(lessThan);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThan> tupled() {
        return LessThan$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThan>> curried() {
        return LessThan$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lt(input1, input2));
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public LessThan copy(Expression left, Expression right) {
        return new LessThan(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThan";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThan)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThan lessThan = (LessThan)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThan.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThan.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThan.canEqual(this)) return false;
        return true;
    }

    public LessThan(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

