/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigInteger;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class BigIntegerStringConverter
implements TypeConverter<BigInteger, String> {
    private static final long serialVersionUID = 2695605770119124000L;

    @Override
    public BigInteger toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new BigInteger(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, BigInteger.class.getName()), nfe);
        }
    }

    @Override
    public String toDatastoreType(BigInteger bi) {
        return bi != null ? bi.toString() : null;
    }
}

