/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.runtime.StreamExecution$;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.MaintenanceTaskType;
import org.apache.spark.sql.execution.streaming.state.MaintenanceTaskType$FromLoadedProviders$;
import org.apache.spark.sql.execution.streaming.state.MaintenanceTaskType$FromTaskThread$;
import org.apache.spark.sql.execution.streaming.state.MaintenanceTaskType$FromUnloadedProvidersQueue$;
import org.apache.spark.sql.execution.streaming.state.ReadStateStore;
import org.apache.spark.sql.execution.streaming.state.StateSchemaBroadcast;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class StateStore$
implements Logging {
    public static final StateStore$ MODULE$ = new StateStore$();
    private static final int PARTITION_ID_TO_CHECK_SCHEMA;
    private static final String DEFAULT_COL_FAMILY_NAME;
    @GuardedBy(value="loadedProviders")
    private static final HashMap<StateStoreProviderId, StateStoreProvider> loadedProviders;
    private static final Object maintenanceThreadPoolLock;
    private static final ConcurrentLinkedQueue<Tuple2<StateStoreProviderId, StateStoreProvider>> unloadedProvidersToClose;
    @GuardedBy(value="maintenanceThreadPoolLock")
    private static final HashSet<StateStoreProviderId> maintenancePartitions;
    @GuardedBy(value="loadedProviders")
    private static StateStore.MaintenanceTask maintenanceTask;
    @GuardedBy(value="loadedProviders")
    private static StateStore.MaintenanceThreadPool maintenanceThreadPool;
    @GuardedBy(value="loadedProviders")
    private static StateStoreCoordinatorRef _coordRef;
    private static volatile boolean maintenancePaused;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        PARTITION_ID_TO_CHECK_SCHEMA = 0;
        DEFAULT_COL_FAMILY_NAME = "default";
        loadedProviders = new HashMap();
        maintenanceThreadPoolLock = new Object();
        unloadedProvidersToClose = new ConcurrentLinkedQueue();
        maintenancePartitions = new HashSet();
        maintenanceTask = null;
        maintenanceThreadPool = null;
        _coordRef = null;
        maintenancePaused = false;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int PARTITION_ID_TO_CHECK_SCHEMA() {
        return PARTITION_ID_TO_CHECK_SCHEMA;
    }

    public String DEFAULT_COL_FAMILY_NAME() {
        return DEFAULT_COL_FAMILY_NAME;
    }

    private HashMap<StateStoreProviderId, StateStoreProvider> loadedProviders() {
        return loadedProviders;
    }

    private Object maintenanceThreadPoolLock() {
        return maintenanceThreadPoolLock;
    }

    private ConcurrentLinkedQueue<Tuple2<StateStoreProviderId, StateStoreProvider>> unloadedProvidersToClose() {
        return unloadedProvidersToClose;
    }

    private HashSet<StateStoreProviderId> maintenancePartitions() {
        return maintenancePartitions;
    }

    public void reportCommitToCoordinator(long version, StateStoreId stateStoreId, Configuration hadoopConf) {
        try {
            UUID runId = UUID.fromString(StateStoreProvider$.MODULE$.getRunId(hadoopConf));
            StateStoreProviderId providerId = new StateStoreProviderId(stateStoreId, runId);
            StateStoreProvider$.MODULE$.coordinatorRef().foreach((Function1 & Serializable)x$12 -> {
                x$12.reportStateStoreCommit(providerId, version, stateStoreId.storeName());
                return BoxedUnit.UNIT;
            });
            this.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reported commit for store "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " at version ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STATE_STORE_ID, stateStoreId), MODULE$.MDC((LogKey)LogKeys.VERSION_NUM, BoxesRunTime.boxToLong((long)version))})))));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to report StateStore commit: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.EXCEPTION, throwable2)}))));
            }
            throw throwable;
        }
    }

    private StateStore.MaintenanceTask maintenanceTask() {
        return maintenanceTask;
    }

    private void maintenanceTask_$eq(StateStore.MaintenanceTask x$1) {
        maintenanceTask = x$1;
    }

    private StateStore.MaintenanceThreadPool maintenanceThreadPool() {
        return maintenanceThreadPool;
    }

    private void maintenanceThreadPool_$eq(StateStore.MaintenanceThreadPool x$1) {
        maintenanceThreadPool = x$1;
    }

    private StateStoreCoordinatorRef _coordRef() {
        return _coordRef;
    }

    private void _coordRef_$eq(StateStoreCoordinatorRef x$1) {
        _coordRef = x$1;
    }

    public ReadStateStore getReadOnly(StateStoreProviderId storeProviderId, StructType keySchema, StructType valueSchema, KeyStateEncoderSpec keyStateEncoderSpec, long version, Option<String> stateStoreCkptId, Option<StateSchemaBroadcast> stateSchemaBroadcast, boolean useColumnFamilies, StateStoreConf storeConf, Configuration hadoopConf, boolean useMultipleValuesPerKey) {
        hadoopConf.set(StreamExecution$.MODULE$.RUN_ID_KEY(), storeProviderId.queryRunId().toString());
        if (version < 0L) {
            throw QueryExecutionErrors$.MODULE$.unexpectedStateStoreVersion(version);
        }
        StateStoreProvider storeProvider = this.getStateStoreProvider(storeProviderId, keySchema, valueSchema, keyStateEncoderSpec, useColumnFamilies, storeConf, hadoopConf, useMultipleValuesPerKey, stateSchemaBroadcast);
        return storeProvider.getReadStore(version, stateStoreCkptId);
    }

    public StateStore getWriteStore(ReadStateStore readStore, StateStoreProviderId storeProviderId, StructType keySchema, StructType valueSchema, KeyStateEncoderSpec keyStateEncoderSpec, long version, Option<String> stateStoreCkptId, Option<StateSchemaBroadcast> stateSchemaBroadcast, boolean useColumnFamilies, StateStoreConf storeConf, Configuration hadoopConf, boolean useMultipleValuesPerKey) {
        hadoopConf.set(StreamExecution$.MODULE$.RUN_ID_KEY(), storeProviderId.queryRunId().toString());
        if (version < 0L) {
            throw QueryExecutionErrors$.MODULE$.unexpectedStateStoreVersion(version);
        }
        StateStoreProvider storeProvider = this.getStateStoreProvider(storeProviderId, keySchema, valueSchema, keyStateEncoderSpec, useColumnFamilies, storeConf, hadoopConf, useMultipleValuesPerKey, stateSchemaBroadcast);
        return storeProvider.upgradeReadStoreToWriteStore(readStore, version, stateStoreCkptId);
    }

    public StateStore get(StateStoreProviderId storeProviderId, StructType keySchema, StructType valueSchema, KeyStateEncoderSpec keyStateEncoderSpec, long version, Option<String> stateStoreCkptId, Option<StateSchemaBroadcast> stateSchemaBroadcast, boolean useColumnFamilies, StateStoreConf storeConf, Configuration hadoopConf, boolean useMultipleValuesPerKey) {
        hadoopConf.set(StreamExecution$.MODULE$.RUN_ID_KEY(), storeProviderId.queryRunId().toString());
        if (version < 0L) {
            throw QueryExecutionErrors$.MODULE$.unexpectedStateStoreVersion(version);
        }
        StateStoreProvider storeProvider = this.getStateStoreProvider(storeProviderId, keySchema, valueSchema, keyStateEncoderSpec, useColumnFamilies, storeConf, hadoopConf, useMultipleValuesPerKey, stateSchemaBroadcast);
        return storeProvider.getStore(version, stateStoreCkptId);
    }

    public boolean getReadOnly$default$11() {
        return false;
    }

    public boolean getWriteStore$default$12() {
        return false;
    }

    public boolean get$default$11() {
        return false;
    }

    private StateStoreProvider getStateStoreProvider(StateStoreProviderId storeProviderId, StructType keySchema, StructType valueSchema, KeyStateEncoderSpec keyStateEncoderSpec, boolean useColumnFamilies, StateStoreConf storeConf, Configuration hadoopConf, boolean useMultipleValuesPerKey, Option<StateSchemaBroadcast> stateSchemaBroadcast) {
        StateStoreProvider stateStoreProvider;
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            this.startMaintenanceIfNeeded(storeConf);
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0 & Serializable)() -> (StateStoreProvider)MODULE$.loadedProviders().getOrElseUpdate((Object)storeProviderId, (Function0 & Serializable)() -> StateStoreProvider$.MODULE$.createAndInit(storeProviderId, keySchema, valueSchema, keyStateEncoderSpec, useColumnFamilies, storeConf, hadoopConf, useMultipleValuesPerKey, (Option<StateSchemaProvider>)stateSchemaBroadcast)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StateStoreProvider provider = (StateStoreProvider)tuple2._1();
            long loadTimeMs = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)provider, (Object)BoxesRunTime.boxToLong((long)loadTimeMs));
            StateStoreProvider provider2 = (StateStoreProvider)tuple22._1();
            long loadTimeMs2 = tuple22._2$mcJ$sp();
            if (loadTimeMs2 > 2000L) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded state store provider in loadTimeMs="}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.LOAD_TIME, BoxesRunTime.boxToLong((long)loadTimeMs2))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for storeId=", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STORE_ID, storeProviderId.storeId().toString())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"queryRunId=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.QUERY_RUN_ID, storeProviderId.queryRunId())})))));
            }
            if (!storeConf.unloadOnCommit()) {
                Seq otherProviderIds = ((IterableOnceOps)this.loadedProviders().keys().filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)StateStore$.$anonfun$getStateStoreProvider$4(storeProviderId, x$14)))).toSeq();
                Seq<StateStoreProviderId> providerIdsToUnload = this.reportActiveStoreInstance(storeProviderId, (Seq<StateStoreProviderId>)otherProviderIds);
                MessageWithContext taskContextIdLogLine = (MessageWithContext)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable)tc -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"taskId=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TASK_ID, BoxesRunTime.boxToLong((long)tc.taskAttemptId()))}))).getOrElse((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))).log((Seq)Nil$.MODULE$));
                providerIdsToUnload.foreach((Function1 & Serializable)id -> {
                    StateStore$.$anonfun$getStateStoreProvider$7(taskContextIdLogLine, storeConf, id);
                    return BoxedUnit.UNIT;
                });
            }
            stateStoreProvider = provider2;
        }
        return stateStoreProvider;
    }

    public void doMaintenanceAndUnload(StateStoreProviderId storeProviderId) {
        Option option;
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            option = this.loadedProviders().remove((Object)storeProviderId);
        }
        option.foreach((Function1 & Serializable)provider -> {
            StateStore$.$anonfun$doMaintenanceAndUnload$1(provider);
            return BoxedUnit.UNIT;
        });
    }

    public void removeFromLoadedProvidersAndClose(StateStoreProviderId storeProviderId, Option<StateStoreProvider> alreadyRemovedProvider) {
        Option providerToClose = alreadyRemovedProvider.orElse((Function0 & Serializable)() -> {
            Option option;
            HashMap<StateStoreProviderId, StateStoreProvider> hashMap = MODULE$.loadedProviders();
            synchronized (hashMap) {
                option = MODULE$.loadedProviders().remove((Object)storeProviderId);
            }
            return option;
        });
        providerToClose.foreach((Function1 & Serializable)provider -> {
            provider.close();
            return BoxedUnit.UNIT;
        });
    }

    public Option<StateStoreProvider> removeFromLoadedProvidersAndClose$default$2() {
        return None$.MODULE$;
    }

    public void unloadAll() {
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            this.loadedProviders().keySet().foreach((Function1 & Serializable)key -> {
                StateStore$.MODULE$.removeFromLoadedProvidersAndClose(key, StateStore$.MODULE$.removeFromLoadedProvidersAndClose$default$2());
                return BoxedUnit.UNIT;
            });
            this.loadedProviders().clear();
        }
    }

    public boolean isLoaded(StateStoreProviderId storeProviderId) {
        boolean bl;
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            bl = this.loadedProviders().contains((Object)storeProviderId);
        }
        return bl;
    }

    public boolean isMaintenanceRunning() {
        boolean bl;
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            bl = this.maintenanceTask() != null && this.maintenanceTask().isRunning();
        }
        return bl;
    }

    public void stopMaintenanceTask() {
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            this.stopMaintenanceTaskWithoutLock();
        }
    }

    public void stopMaintenanceTaskWithoutLock() {
        if (this.maintenanceThreadPool() != null) {
            Object object = this.maintenanceThreadPoolLock();
            synchronized (object) {
                this.maintenancePartitions().clear();
            }
            this.maintenanceThreadPool().stop();
            this.maintenanceThreadPool_$eq(null);
        }
        if (this.maintenanceTask() != null) {
            this.maintenanceTask().stop();
            this.maintenanceTask_$eq(null);
            return;
        }
    }

    public void stop() {
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            this.loadedProviders().keySet().foreach((Function1 & Serializable)key -> {
                StateStore$.MODULE$.removeFromLoadedProvidersAndClose(key, StateStore$.MODULE$.removeFromLoadedProvidersAndClose$default$2());
                return BoxedUnit.UNIT;
            });
            this.loadedProviders().clear();
            this._coordRef_$eq(null);
            this.stopMaintenanceTask();
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "StateStore stopped");
        }
    }

    private void startMaintenanceIfNeeded(StateStoreConf storeConf) {
        int numMaintenanceThreads = storeConf.numStateStoreMaintenanceThreads();
        long maintenanceShutdownTimeout = storeConf.stateStoreMaintenanceShutdownTimeout();
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            if (SparkEnv$.MODULE$.get() != null && !this.isMaintenanceRunning() && !storeConf.unloadOnCommit()) {
                this.maintenanceTask_$eq(new StateStore.MaintenanceTask(storeConf.maintenanceInterval(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.doMaintenance(storeConf)));
                this.maintenanceThreadPool_$eq(new StateStore.MaintenanceThreadPool(numMaintenanceThreads, maintenanceShutdownTimeout));
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "State Store maintenance task started");
            }
        }
    }

    private boolean awaitProcessThisPartition(StateStoreProviderId id, long timeoutMs) {
        boolean bl;
        Object object = this.maintenanceThreadPoolLock();
        synchronized (object) {
            long startTime = System.currentTimeMillis();
            long endTime = startTime + timeoutMs;
            boolean canProcessThisPartition = this.processThisPartition(id);
            while (!canProcessThisPartition && System.currentTimeMillis() < endTime) {
                this.maintenanceThreadPoolLock().wait(timeoutMs);
                canProcessThisPartition = this.processThisPartition(id);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Waited for ", " ms to be able to process "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TOTAL_TIME, BoxesRunTime.boxToLong((long)elapsedTime))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"maintenance for partition ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STATE_STORE_PROVIDER_ID, id)})))));
            bl = canProcessThisPartition;
        }
        return bl;
    }

    private void doMaintenance() {
        this.doMaintenance(StateStoreConf$.MODULE$.empty());
    }

    private boolean processThisPartition(StateStoreProviderId id) {
        boolean bl;
        Object object = this.maintenanceThreadPoolLock();
        synchronized (object) {
            boolean bl2;
            if (!this.maintenancePartitions().contains((Object)id)) {
                this.maintenancePartitions().add((Object)id);
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private boolean maintenancePaused() {
        return maintenancePaused;
    }

    private void maintenancePaused_$eq(boolean x$1) {
        maintenancePaused = x$1;
    }

    public void setMaintenancePaused(boolean maintPaused) {
        this.maintenancePaused_$eq(maintPaused);
    }

    private void doMaintenance(StateStoreConf storeConf) {
        Seq seq;
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Doing maintenance");
        if (SparkEnv$.MODULE$.get() == null) {
            throw new IllegalStateException("SparkEnv not active, cannot do maintenance on StateStores");
        }
        if (this.maintenancePaused()) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Maintenance paused");
            return;
        }
        ArrayBuffer providersToRequeue = new ArrayBuffer();
        while (!this.unloadedProvidersToClose().isEmpty()) {
            BoxedUnit boxedUnit;
            Tuple2<StateStoreProviderId, StateStoreProvider> tuple2 = this.unloadedProvidersToClose().poll();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            StateStoreProviderId providerId = (StateStoreProviderId)tuple2._1();
            StateStoreProvider provider = (StateStoreProvider)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)providerId, (Object)provider);
            StateStoreProviderId providerId2 = (StateStoreProviderId)tuple22._1();
            StateStoreProvider provider2 = (StateStoreProvider)tuple22._2();
            if (this.processThisPartition(providerId2)) {
                this.submitMaintenanceWorkForProvider(providerId2, provider2, storeConf, MaintenanceTaskType$FromUnloadedProvidersQueue$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = providersToRequeue.$plus$eq((Object)new Tuple2((Object)providerId2, (Object)provider2));
        }
        if (providersToRequeue.nonEmpty()) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Had to requeue ", " providers "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.SIZE, BoxesRunTime.boxToInteger((int)providersToRequeue.size()))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for maintenance in doMaintenance"}))).log((Seq)Nil$.MODULE$))));
        }
        providersToRequeue.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StateStore$.$anonfun$doMaintenance$4(x$1)));
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            seq = this.loadedProviders().toSeq();
        }
        seq.foreach((Function1 & Serializable)x0$1 -> {
            StateStore$.$anonfun$doMaintenance$5(storeConf, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void submitMaintenanceWorkForProvider(StateStoreProviderId id, StateStoreProvider provider, StateStoreConf storeConf, MaintenanceTaskType source) {
        this.maintenanceThreadPool().execute(() -> {
            boolean bl;
            long startTime = System.currentTimeMillis();
            MaintenanceTaskType maintenanceTaskType = source;
            if (MaintenanceTaskType$FromTaskThread$.MODULE$.equals(maintenanceTaskType)) {
                long timeoutMs = storeConf.stateStoreMaintenanceProcessingTimeout() * 1000L;
                boolean ableToProcessNow = MODULE$.awaitProcessThisPartition(id, timeoutMs);
                Object object = !ableToProcessNow ? BoxesRunTime.boxToBoolean((boolean)MODULE$.unloadedProvidersToClose().add((Tuple2<StateStoreProviderId, StateStoreProvider>)new Tuple2((Object)id, (Object)provider))) : BoxedUnit.UNIT;
                bl = ableToProcessNow;
            } else if (MaintenanceTaskType$FromUnloadedProvidersQueue$.MODULE$.equals(maintenanceTaskType)) {
                bl = true;
            } else if (MaintenanceTaskType$FromLoadedProviders$.MODULE$.equals(maintenanceTaskType)) {
                bl = true;
            } else {
                throw new MatchError((Object)maintenanceTaskType);
            }
            boolean canProcessThisPartition = bl;
            if (canProcessThisPartition) {
                long awaitingPartitionDuration;
                block29: {
                    awaitingPartitionDuration = System.currentTimeMillis() - startTime;
                    try {
                        try {
                            provider.doMaintenance();
                            MaintenanceTaskType maintenanceTaskType2 = source;
                            if (MaintenanceTaskType$FromTaskThread$.MODULE$.equals(maintenanceTaskType2) ? true : MaintenanceTaskType$FromUnloadedProvidersQueue$.MODULE$.equals(maintenanceTaskType2)) {
                                MODULE$.removeFromLoadedProvidersAndClose(id, (Option<StateStoreProvider>)new Some((Object)provider));
                            } else if (MaintenanceTaskType$FromLoadedProviders$.MODULE$.equals(maintenanceTaskType2)) {
                                if (!MODULE$.verifyIfStoreInstanceActive(id)) {
                                    MODULE$.removeFromLoadedProvidersAndClose(id, MODULE$.removeFromLoadedProvidersAndClose$default$2());
                                }
                            } else {
                                throw new MatchError((Object)maintenanceTaskType2);
                            }
                            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unloaded ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STATE_STORE_PROVIDER_ID, id)}))));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            Throwable throwable3 = throwable;
                            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                                MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error doing maintenance on provider:"}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" ", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STATE_STORE_PROVIDER_ID, id)}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Could not unload state store provider"}))).log((Seq)Nil$.MODULE$))), throwable2);
                                MaintenanceTaskType maintenanceTaskType3 = source;
                                if (MaintenanceTaskType$FromTaskThread$.MODULE$.equals(maintenanceTaskType3) ? true : MaintenanceTaskType$FromUnloadedProvidersQueue$.MODULE$.equals(maintenanceTaskType3)) {
                                    MODULE$.removeFromLoadedProvidersAndClose(id, (Option<StateStoreProvider>)new Some((Object)provider));
                                    break block29;
                                }
                                if (MaintenanceTaskType$FromLoadedProviders$.MODULE$.equals(maintenanceTaskType3)) {
                                    MODULE$.removeFromLoadedProvidersAndClose(id, MODULE$.removeFromLoadedProvidersAndClose$default$2());
                                    break block29;
                                }
                                throw new MatchError((Object)maintenanceTaskType3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        long duration = System.currentTimeMillis() - startTime;
                        MessageWithContext logMsg = MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Finished maintenance task for "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"provider=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STATE_STORE_PROVIDER_ID, id)}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" in elapsed_time=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TIME_UNITS, BoxesRunTime.boxToLong((long)duration))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" and awaiting_partition_time="}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TIME_UNITS, BoxesRunTime.boxToLong((long)awaitingPartitionDuration))})));
                        if (duration > 5000L) {
                            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> logMsg));
                        } else {
                            MODULE$.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> logMsg));
                        }
                        Object object = MODULE$.maintenanceThreadPoolLock();
                        synchronized (object) {
                            MODULE$.maintenancePartitions().remove((Object)id);
                            MODULE$.maintenanceThreadPoolLock().notifyAll();
                        }
                        throw throwable;
                    }
                }
                long duration = System.currentTimeMillis() - startTime;
                MessageWithContext logMsg = MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Finished maintenance task for "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"provider=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STATE_STORE_PROVIDER_ID, id)}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" in elapsed_time=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TIME_UNITS, BoxesRunTime.boxToLong((long)duration))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" and awaiting_partition_time="}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TIME_UNITS, BoxesRunTime.boxToLong((long)awaitingPartitionDuration))})));
                if (duration > 5000L) {
                    MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> logMsg));
                } else {
                    MODULE$.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> logMsg));
                }
                Object object = MODULE$.maintenanceThreadPoolLock();
                synchronized (object) {
                    MODULE$.maintenancePartitions().remove((Object)id);
                    MODULE$.maintenanceThreadPoolLock().notifyAll();
                }
                return;
            }
        });
    }

    private MaintenanceTaskType submitMaintenanceWorkForProvider$default$4() {
        return MaintenanceTaskType$FromLoadedProviders$.MODULE$;
    }

    private Seq<StateStoreProviderId> reportActiveStoreInstance(StateStoreProviderId storeProviderId, Seq<StateStoreProviderId> otherProviderIds) {
        if (SparkEnv$.MODULE$.get() != null) {
            String host = SparkEnv$.MODULE$.get().blockManager().blockManagerId().host();
            String executorId = SparkEnv$.MODULE$.get().blockManager().blockManagerId().executorId();
            Seq providerIdsToUnload = (Seq)this.coordinatorRef().map((Function1 & Serializable)x$16 -> x$16.reportActiveInstance(storeProviderId, host, executorId, otherProviderIds)).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reported that the loaded instance "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is active"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STATE_STORE_PROVIDER_ID, storeProviderId)})))));
            this.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The loaded instances are going to unload: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STATE_STORE_PROVIDER_IDS, providerIdsToUnload)})))));
            return providerIdsToUnload;
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private boolean verifyIfStoreInstanceActive(StateStoreProviderId storeProviderId) {
        if (SparkEnv$.MODULE$.get() != null) {
            String executorId = SparkEnv$.MODULE$.get().blockManager().blockManagerId().executorId();
            boolean verified = BoxesRunTime.unboxToBoolean((Object)this.coordinatorRef().map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.verifyIfInstanceActive(storeProviderId, executorId))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Verified whether the loaded instance " + storeProviderId + " is active: " + verified);
            return verified;
        }
        return false;
    }

    private Option<StateStoreCoordinatorRef> coordinatorRef() {
        None$ none$;
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.loadedProviders();
        synchronized (hashMap) {
            None$ none$2;
            SparkEnv env = SparkEnv$.MODULE$.get();
            if (env != null) {
                boolean isDriver;
                String string = env.executorId();
                String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (isDriver = false);
                if (isDriver || this._coordRef() == null) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Getting StateStoreCoordinatorRef");
                    this._coordRef_$eq(StateStoreCoordinatorRef$.MODULE$.forExecutor(env));
                }
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Retrieved reference to StateStoreCoordinator: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STATE_STORE_COORDINATOR, MODULE$._coordRef())})))));
                none$2 = new Some((Object)this._coordRef());
            } else {
                this._coordRef_$eq(null);
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$getStateStoreProvider$4(StateStoreProviderId storeProviderId$1, StateStoreProviderId x$14) {
        StateStoreProviderId stateStoreProviderId = x$14;
        StateStoreProviderId stateStoreProviderId2 = storeProviderId$1;
        return stateStoreProviderId == null ? stateStoreProviderId2 != null : !((Object)stateStoreProviderId).equals(stateStoreProviderId2);
    }

    public static final /* synthetic */ void $anonfun$getStateStoreProvider$8(StateStoreProviderId id$1, MessageWithContext taskContextIdLogLine$1, StateStoreConf storeConf$1, StateStoreProvider provider) {
        MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Submitted maintenance from task thread to close "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"provider=", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STATE_STORE_PROVIDER_ID, id$1)}))).$plus(taskContextIdLogLine$1).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Removed provider from loadedProviders"}))).log((Seq)Nil$.MODULE$))));
        MODULE$.submitMaintenanceWorkForProvider(id$1, provider, storeConf$1, MaintenanceTaskType$FromTaskThread$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$getStateStoreProvider$7(MessageWithContext taskContextIdLogLine$1, StateStoreConf storeConf$1, StateStoreProviderId id) {
        MODULE$.loadedProviders().remove((Object)id).foreach((Function1 & Serializable)provider -> {
            StateStore$.$anonfun$getStateStoreProvider$8(id, taskContextIdLogLine$1, storeConf$1, provider);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$doMaintenanceAndUnload$1(StateStoreProvider provider) {
        provider.doMaintenance();
        provider.close();
    }

    public static final /* synthetic */ boolean $anonfun$doMaintenance$4(Tuple2 x$1) {
        return MODULE$.unloadedProvidersToClose().offer((Tuple2<StateStoreProviderId, StateStoreProvider>)x$1);
    }

    public static final /* synthetic */ void $anonfun$doMaintenance$5(StateStoreConf storeConf$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StateStoreProviderId id = (StateStoreProviderId)tuple2._1();
            StateStoreProvider provider = (StateStoreProvider)tuple2._2();
            if (MODULE$.processThisPartition(id)) {
                MODULE$.submitMaintenanceWorkForProvider(id, provider, storeConf$3, MaintenanceTaskType$FromLoadedProviders$.MODULE$);
                return;
            }
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Not processing partition ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PARTITION_ID, id)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for maintenance because it is currently "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"being processed"}))).log((Seq)Nil$.MODULE$))));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private StateStore$() {
    }
}

