/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TryToDateExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to a date.\n      The function always returns null on an invalid input with/without ANSI SQL mode enabled. By\n      default, it follows casting rules to a date if the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31');\n       2016-12-31\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n      > SELECT _FUNC_('foo', 'yyyy-MM-dd');\n       NULL\n  ", group="datetime_funcs", since="4.0.0")
@ScalaSignature(bytes="\u0006\u0005Q;Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015\n!\u0004\u0016:z)>$\u0015\r^3FqB\u0014Xm]:j_:\u0014U/\u001b7eKJT!AB\u0004\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0011%\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001\u0001\t\u0003'\u0005i\u0011!\u0002\u0002\u001b)JLHk\u001c#bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM]\n\u0004\u0003Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001eA5\taD\u0003\u0002 \u000f\u0005A\u0011M\\1msNL7/\u0003\u0002\"=\t\tR\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0002\rqJg.\u001b;?)\u0005\u0011\u0012!\u00022vS2$Gc\u0001\u0014*mA\u00111cJ\u0005\u0003Q\u0015\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015Q3\u00011\u0001,\u0003!1WO\\2OC6,\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/15\tqF\u0003\u00021#\u00051AH]8pizJ!A\r\r\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003eaAQAB\u0002A\u0002]\u00022\u0001O\u001f'\u001d\tI4H\u0004\u0002/u%\t\u0011$\u0003\u0002=1\u00059\u0001/Y2lC\u001e,\u0017B\u0001 @\u0005\r\u0019V-\u001d\u0006\u0003yaAC\"A!E\u000b\u001eC%jS'O!F\u0003\"a\u0005\"\n\u0005\r+!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0002\r\u0006\u0011IC\u0003\u0011!A\u0001zf)\u0016(D?\"\"\u0017\r^3`gR\u00148\f\f\u0011g[Rl\u0016\u0006I\u0017!!\u0006\u00148/Z:!i\",\u0007\u0005\u00193bi\u0016|6\u000f\u001e:aA\u0015D\bO]3tg&|g\u000eI<ji\"\u0004C\u000f[3!A\u001alG\u000f\u0019\u0011fqB\u0014Xm]:j_:\u0004Co\u001c\u0011bA\u0011\fG/\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI1mo\u0006L8\u000f\t:fiV\u0014hn\u001d\u0011ok2d\u0007e\u001c8!C:\u0004\u0013N\u001c<bY&$\u0007%\u001b8qkR\u0004s/\u001b;i_]LG\u000f[8vi\u0002\nejU%!'Fc\u0005%\\8eK\u0002*g.\u00192mK\u0012t\u0003EQ=\u000bA\u0001\u0002\u0003\u0005\t\u0011eK\u001a\fW\u000f\u001c;-A%$\bEZ8mY><8\u000fI2bgRLgn\u001a\u0011sk2,7\u000f\t;pA\u0005\u0004C-\u0019;fA%4\u0007\u0005\u001e5fA\u00014W\u000e\u001e1!SN\u0004s.\\5ui\u0016$gF\u0003\u0011!\u0003%\t'oZ;nK:$8/I\u0001J\u0003\t}!\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011eCR,wl\u001d;sA5\u0002\u0013\tI:ue&tw\r\t;pA\t,\u0007\u0005]1sg\u0016$\u0007\u0005^8!I\u0006$XM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!M6$\b%\f\u0011ECR,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014h\u000e\t;pA\u0019|G\u000e\\8x]\u0001\u001aV-\u001a\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006Z1uKRLW.Z\u0017qCR$XM\u001d8/QRlGN\t ECR,G/[7fAA\u000bG\u000f^3s]Ndt&\u0019 !M>\u0014\bE^1mS\u0012T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C-\u0019;fA\u0005tG\r\t;j[\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt7O\f\u0006!A\u0005AQ\r_1na2,7/I\u0001M\u0003\u0005-%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T&\r\u001a.gE:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE2T&\r\u001a.gER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0013GM\u00174c\u001db\u0003eJ=zsflS*T\u0017eI\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYj\u0013GM\u00174c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsEZ8pO1\u0002s%_=zs6jU*\f3eO%Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003he>,\b/I\u0001P\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f\u0013AU\u0001\u0006i9\u0002d\u0006\r\u0015\r\u0001\u0005#Ui\u0012%K\u00176s\u0005+\u0015")
public final class TryToDateExpressionBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return TryToDateExpressionBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return TryToDateExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return TryToDateExpressionBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName, resolver);
    }

    public static Option<FunctionSignature> functionSignature() {
        return TryToDateExpressionBuilder$.MODULE$.functionSignature();
    }
}

