/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="posexplode", value="_FUNC_(a) - behaves like explode for arrays, but includes the position of items in the original array")
public class GenericUDTFPosExplode
extends GenericUDTF {
    private ListObjectInspector listOI = null;
    private final Object[] forwardObj = new Object[2];

    @Override
    public void close() throws HiveException {
    }

    @Override
    public StructObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length != 1) {
            throw new UDFArgumentException("posexplode() takes only one argument");
        }
        if (args[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("posexplode() takes an array as a parameter");
        }
        this.listOI = (ListObjectInspector)args[0];
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<Object> fieldOIs = new ArrayList<Object>();
        fieldNames.add("pos");
        fieldNames.add("val");
        fieldOIs.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT));
        fieldOIs.add(this.listOI.getListElementObjectInspector());
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    @Override
    public void process(Object[] o) throws HiveException {
        List list = this.listOI.getList(o[0]);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object r = list.get(i);
            this.forwardObj[0] = new Integer(i);
            this.forwardObj[1] = r;
            this.forward(this.forwardObj);
        }
    }

    public String toString() {
        return "posexplode";
    }
}

