/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.DecisionTreeRegressorWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.regression.DecisionTreeRegressor;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class DecisionTreeRegressorWrapper$
implements MLReadable<DecisionTreeRegressorWrapper> {
    public static final DecisionTreeRegressorWrapper$ MODULE$ = new DecisionTreeRegressorWrapper$();

    static {
        MLReadable.$init$(MODULE$);
    }

    public DecisionTreeRegressorWrapper fit(Dataset<Row> data, String formula, int maxDepth, int maxBins, String impurity, int minInstancesPerNode, double minInfoGain, int checkpointInterval, String seed, int maxMemoryInMB, boolean cacheNodeIds) {
        RFormula rFormula = new RFormula().setFormula(formula);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormulaModel).getFeaturesCol())).attributes().get();
        String[] features = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])featureAttrs), (Function1 & Serializable)x$1 -> (String)x$1.name().get(), ClassTag$.MODULE$.apply(String.class));
        DecisionTreeRegressor dtr = (DecisionTreeRegressor)new DecisionTreeRegressor().setMaxDepth(maxDepth).setMaxBins(maxBins).setImpurity(impurity).setMinInstancesPerNode(minInstancesPerNode).setMinInfoGain(minInfoGain).setCheckpointInterval(checkpointInterval).setMaxMemoryInMB(maxMemoryInMB).setCacheNodeIds(cacheNodeIds).setFeaturesCol(rFormula.getFeaturesCol());
        Object object = seed != null && seed.length() > 0 ? dtr.setSeed(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(seed))) : BoxedUnit.UNIT;
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, dtr})).fit((Dataset)data);
        return new DecisionTreeRegressorWrapper((PipelineModel)pipeline, formula, features);
    }

    @Override
    public MLReader<DecisionTreeRegressorWrapper> read() {
        return new DecisionTreeRegressorWrapper.DecisionTreeRegressorWrapperReader();
    }

    @Override
    public DecisionTreeRegressorWrapper load(String path) {
        return (DecisionTreeRegressorWrapper)MLReadable.load$(this, path);
    }

    private DecisionTreeRegressorWrapper$() {
    }
}

