/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.clustering.PowerIterationClustering;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaPowerIterationClusteringExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaPowerIterationClustering").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{0L, 1L, 1.0}), RowFactory.create((Object[])new Object[]{0L, 2L, 1.0}), RowFactory.create((Object[])new Object[]{1L, 2L, 1.0}), RowFactory.create((Object[])new Object[]{3L, 4L, 1.0}), RowFactory.create((Object[])new Object[]{4L, 0L, 0.1}));
        StructType schema = new StructType(new StructField[]{new StructField("src", DataTypes.LongType, false, Metadata.empty()), new StructField("dst", DataTypes.LongType, false, Metadata.empty()), new StructField("weight", DataTypes.DoubleType, false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        PowerIterationClustering model = new PowerIterationClustering().setK(2).setMaxIter(10).setInitMode("degree").setWeightCol("weight");
        Dataset result = model.assignClusters(df);
        result.show(false);
        spark.stop();
    }
}

