/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;
import org.apache.flink.api.java.tuple.Tuple;

@Internal
public class TupleSummaryAggregator<R extends Tuple>
implements Aggregator<Tuple, R> {
    private static final long serialVersionUID = 1L;
    private final Aggregator[] columnAggregators;

    public TupleSummaryAggregator(Aggregator[] columnAggregators) {
        this.columnAggregators = columnAggregators;
    }

    @Override
    public void aggregate(Tuple value) {
        for (int i = 0; i < this.columnAggregators.length; ++i) {
            this.columnAggregators[i].aggregate(value.getField(i));
        }
    }

    @Override
    public void combine(Aggregator<Tuple, R> other) {
        TupleSummaryAggregator tupleSummaryAggregator = (TupleSummaryAggregator)other;
        for (int i = 0; i < this.columnAggregators.length; ++i) {
            this.columnAggregators[i].combine(tupleSummaryAggregator.columnAggregators[i]);
        }
    }

    @Override
    public R result() {
        try {
            Class tupleClass = Tuple.getTupleClass((int)this.columnAggregators.length);
            Tuple tuple = (Tuple)tupleClass.newInstance();
            for (int i = 0; i < this.columnAggregators.length; ++i) {
                tuple.setField(this.columnAggregators[i].result(), i);
            }
            return (R)tuple;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unexpected error instantiating Tuple class for aggregation results", e);
        }
    }
}

