/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import java.math.BigInteger;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class BigIntParser
extends FieldParser<BigInteger> {
    private static final BigInteger BIG_INTEGER_INSTANCE = BigInteger.ZERO;
    private BigInteger result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, BigInteger reusable) {
        int endPos = this.nextStringEndPos(bytes, startPos, limit, delimiter);
        if (endPos < 0) {
            return -1;
        }
        if (endPos > startPos && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[endPos - 1]))) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
            return -1;
        }
        String str = new String(bytes, startPos, endPos - startPos, ConfigConstants.DEFAULT_CHARSET);
        try {
            this.result = new BigInteger(str);
            return endPos == limit ? limit : endPos + delimiter.length;
        }
        catch (NumberFormatException e) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public BigInteger createValue() {
        return BIG_INTEGER_INSTANCE;
    }

    @Override
    public BigInteger getLastResult() {
        return this.result;
    }

    public static final BigInteger parseField(byte[] bytes, int startPos, int length) {
        return BigIntParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final BigInteger parseField(byte[] bytes, int startPos, int length, char delimiter) {
        int limitedLen = BigIntParser.nextStringLength(bytes, startPos, length, delimiter);
        if (limitedLen > 0 && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[startPos + limitedLen - 1]))) {
            throw new NumberFormatException("There is leading or trailing whitespace in the numeric field.");
        }
        String str = new String(bytes, startPos, limitedLen, ConfigConstants.DEFAULT_CHARSET);
        return new BigInteger(str);
    }
}

