/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.ActionNameBuilder;

public abstract class AbstractActionNameBuilder
implements ActionNameBuilder {
    private Set<String> actionSuffix = Collections.singleton("Action");

    @Inject(value="struts.convention.action.suffix", required=false)
    public void setActionSuffix(String actionSuffix) {
        if (StringUtils.isNotBlank((CharSequence)actionSuffix)) {
            this.actionSuffix = TextParseUtil.commaDelimitedStringToSet((String)actionSuffix);
        }
    }

    protected void checkActionName(String actionName) {
        for (String suffix : this.actionSuffix) {
            if (!actionName.equals(suffix)) continue;
            throw new IllegalStateException("The action name cannot be the same as the action suffix [" + suffix + "]");
        }
    }

    protected String truncateSuffixIfMatches(String name) {
        String actionName = name;
        for (String suffix : this.actionSuffix) {
            if (!actionName.endsWith(suffix)) continue;
            actionName = actionName.substring(0, actionName.length() - suffix.length());
        }
        return actionName;
    }
}

