/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import java.util.List;
import java.util.Map;
import kotlinx.serialization.json.Json;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.codec.KotlinSerializationStringEncoder;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class KotlinSerializationJsonEncoder
extends KotlinSerializationStringEncoder<Json> {
    public KotlinSerializationJsonEncoder() {
        this((Json)Json.Default);
    }

    public KotlinSerializationJsonEncoder(Json json) {
        super(json, MediaType.APPLICATION_JSON, new MediaType("application", "*+json"), MediaType.APPLICATION_NDJSON);
        this.setStreamingMediaTypes(List.of(MediaType.APPLICATION_NDJSON));
    }

    @Override
    public Flux<DataBuffer> encodeNonStream(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        JsonArrayJoinHelper helper = new JsonArrayJoinHelper();
        return Flux.from(inputStream).map(value -> this.encodeStreamingValue(value, bufferFactory, elementType, mimeType, hints, helper.getPrefix(), EMPTY_BYTES)).switchIfEmpty((Publisher)Mono.fromCallable(() -> bufferFactory.wrap(helper.getPrefix()))).concatWith((Publisher)Mono.fromCallable(() -> bufferFactory.wrap(helper.getSuffix())));
    }

    private static class JsonArrayJoinHelper {
        private static final byte[] COMMA_SEPARATOR = new byte[]{44};
        private static final byte[] OPEN_BRACKET = new byte[]{91};
        private static final byte[] CLOSE_BRACKET = new byte[]{93};
        private boolean firstItemEmitted;

        private JsonArrayJoinHelper() {
        }

        public byte[] getPrefix() {
            byte[] prefix = this.firstItemEmitted ? COMMA_SEPARATOR : OPEN_BRACKET;
            this.firstItemEmitted = true;
            return prefix;
        }

        public byte[] getSuffix() {
            return CLOSE_BRACKET;
        }
    }
}

