/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityDirectCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityUniversalPromptCredential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.serialization.ComponentSerializationPlanConfigurer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthentication}, module="duo")
@Configuration(value="DuoSecurityComponentSerializationConfiguration", proxyBeanMethods=false)
class DuoSecurityComponentSerializationConfiguration {
    DuoSecurityComponentSerializationConfiguration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"duoSecurityComponentSerializationPlanConfigurer"})
    public ComponentSerializationPlanConfigurer duoSecurityComponentSerializationPlanConfigurer(ConfigurableApplicationContext applicationContext) {
        return (ComponentSerializationPlanConfigurer)BeanSupplier.of(ComponentSerializationPlanConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
            plan.registerSerializableClass(DuoSecurityUniversalPromptCredential.class);
            plan.registerSerializableClass(DuoSecurityDirectCredential.class);
        }).otherwiseProxy().get();
    }
}

