/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.util.ClassUtils;

public enum WebApplicationType {
    NONE,
    SERVLET,
    REACTIVE;

    private static final String[] SERVLET_INDICATOR_CLASSES;
    private static final String WEBMVC_INDICATOR_CLASS = "org.springframework.web.servlet.DispatcherServlet";
    private static final String WEBFLUX_INDICATOR_CLASS = "org.springframework.web.reactive.DispatcherHandler";
    private static final String JERSEY_INDICATOR_CLASS = "org.glassfish.jersey.servlet.ServletContainer";

    static WebApplicationType deduceFromClasspath() {
        if (ClassUtils.isPresent((String)WEBFLUX_INDICATOR_CLASS, null) && !ClassUtils.isPresent((String)WEBMVC_INDICATOR_CLASS, null) && !ClassUtils.isPresent((String)JERSEY_INDICATOR_CLASS, null)) {
            return REACTIVE;
        }
        for (String className : SERVLET_INDICATOR_CLASSES) {
            if (ClassUtils.isPresent((String)className, null)) continue;
            return NONE;
        }
        return SERVLET;
    }

    static {
        SERVLET_INDICATOR_CLASSES = new String[]{"jakarta.servlet.Servlet", "org.springframework.web.context.ConfigurableWebApplicationContext"};
    }

    static class WebApplicationTypeRuntimeHints
    implements RuntimeHintsRegistrar {
        WebApplicationTypeRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            for (String servletIndicatorClass : SERVLET_INDICATOR_CLASSES) {
                this.registerTypeIfPresent(servletIndicatorClass, classLoader, hints);
            }
            this.registerTypeIfPresent(WebApplicationType.JERSEY_INDICATOR_CLASS, classLoader, hints);
            this.registerTypeIfPresent(WebApplicationType.WEBFLUX_INDICATOR_CLASS, classLoader, hints);
            this.registerTypeIfPresent(WebApplicationType.WEBMVC_INDICATOR_CLASS, classLoader, hints);
        }

        private void registerTypeIfPresent(String typeName, ClassLoader classLoader, RuntimeHints hints) {
            if (ClassUtils.isPresent((String)typeName, (ClassLoader)classLoader)) {
                hints.reflection().registerType(TypeReference.of((String)typeName), new MemberCategory[0]);
            }
        }
    }
}

