/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.store.GuavaStore;
import org.pac4j.core.store.Store;
import org.pac4j.core.util.CommonHelper;

public final class CasProxyReceptor
extends IndirectClient {
    public static final String PARAM_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    public static final String PARAM_PROXY_GRANTING_TICKET = "pgtId";
    private Store<String, String> store = new GuavaStore(1000, 1, TimeUnit.MINUTES);

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotNull((String)"store", this.store);
        this.setRedirectionActionBuilderIfUndefined(ctx -> {
            throw new TechnicalException("Not supported by the CAS proxy receptor");
        });
        this.setCredentialsExtractorIfUndefined(ctx -> {
            WebContext webContext = ctx.webContext();
            Optional proxyGrantingTicketIou = webContext.getRequestParameter(PARAM_PROXY_GRANTING_TICKET_IOU);
            this.logger.debug("proxyGrantingTicketIou: {}", (Object)proxyGrantingTicketIou);
            Optional proxyGrantingTicket = webContext.getRequestParameter(PARAM_PROXY_GRANTING_TICKET);
            this.logger.debug("proxyGrantingTicket: {}", (Object)proxyGrantingTicket);
            if (proxyGrantingTicket.isEmpty() || proxyGrantingTicketIou.isEmpty()) {
                this.logger.warn("Missing proxyGrantingTicket or proxyGrantingTicketIou -> returns ok");
                throw new OkAction("");
            }
            this.store.set((Object)((String)proxyGrantingTicketIou.get()), (Object)((String)proxyGrantingTicket.get()));
            this.logger.debug("Found pgtIou and pgtId for CAS proxy receptor -> returns ok");
            throw new OkAction("<?xml version=\"1.0\"?>\n<casClient:proxySuccess xmlns:casClient=\"http://www.yale.edu/tp/casClient\" />");
        });
        this.setAuthenticatorIfUndefined((ctx, credentials) -> {
            throw new TechnicalException("Not supported by the CAS proxy receptor");
        });
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Store<String, String> getStore() {
        return this.store;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStore(Store<String, String> store) {
        this.store = store;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CasProxyReceptor(super=" + super.toString() + ", store=" + this.store + ")";
    }
}

