/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CoordinatorStrategyTest {
    @Test
    public void testBuildOldLookupRequest() {
        CoordinatorStrategy strategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, new LogContext());
        strategy.disableBatch();
        FindCoordinatorRequest.Builder request = strategy.buildRequest(Collections.singleton(CoordinatorKey.byGroupId((String)"foo")));
        Assertions.assertEquals((Object)"foo", (Object)request.data().key());
        Assertions.assertEquals((Object)FindCoordinatorRequest.CoordinatorType.GROUP, (Object)FindCoordinatorRequest.CoordinatorType.forId((byte)request.data().keyType()));
    }

    @Test
    public void testBuildLookupRequest() {
        CoordinatorStrategy strategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, new LogContext());
        FindCoordinatorRequest.Builder request = strategy.buildRequest(new HashSet<CoordinatorKey>(Arrays.asList(CoordinatorKey.byGroupId((String)"foo"), CoordinatorKey.byGroupId((String)"bar"))));
        Assertions.assertEquals((Object)"", (Object)request.data().key());
        Assertions.assertEquals((int)2, (int)request.data().coordinatorKeys().size());
        Assertions.assertEquals((Object)FindCoordinatorRequest.CoordinatorType.GROUP, (Object)FindCoordinatorRequest.CoordinatorType.forId((byte)request.data().keyType()));
    }

    @Test
    public void testBuildLookupRequestNonRepresentable() {
        CoordinatorStrategy strategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, new LogContext());
        FindCoordinatorRequest.Builder request = strategy.buildRequest(new HashSet<CoordinatorKey>(Arrays.asList(CoordinatorKey.byGroupId((String)"foo"), null)));
        Assertions.assertEquals((Object)"", (Object)request.data().key());
        Assertions.assertEquals((int)1, (int)request.data().coordinatorKeys().size());
    }

    @Test
    public void testBuildOldLookupRequestRequiresOneKey() {
        CoordinatorStrategy strategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, new LogContext());
        strategy.disableBatch();
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.buildRequest(Collections.emptySet()));
        CoordinatorKey group1 = CoordinatorKey.byGroupId((String)"foo");
        CoordinatorKey group2 = CoordinatorKey.byGroupId((String)"bar");
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.buildRequest(Utils.mkSet((Object[])new CoordinatorKey[]{group1, group2})));
    }

    @Test
    public void testBuildOldLookupRequestRequiresAtLeastOneKey() {
        CoordinatorStrategy strategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, new LogContext());
        strategy.disableBatch();
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.buildRequest(new HashSet<CoordinatorKey>(Arrays.asList(CoordinatorKey.byTransactionalId((String)"txnid")))));
    }

    @Test
    public void testBuildLookupRequestRequiresAtLeastOneKey() {
        CoordinatorStrategy strategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, new LogContext());
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.buildRequest(Collections.emptySet()));
    }

    @Test
    public void testBuildLookupRequestRequiresKeySameType() {
        CoordinatorStrategy strategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, new LogContext());
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.buildRequest(new HashSet<CoordinatorKey>(Arrays.asList(CoordinatorKey.byGroupId((String)"group"), CoordinatorKey.byTransactionalId((String)"txnid")))));
    }

    @Test
    public void testHandleOldResponseRequiresOneKey() {
        FindCoordinatorResponseData responseData = new FindCoordinatorResponseData().setErrorCode(Errors.NONE.code());
        FindCoordinatorResponse response = new FindCoordinatorResponse(responseData);
        CoordinatorStrategy strategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, new LogContext());
        strategy.disableBatch();
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.handleResponse(Collections.emptySet(), (AbstractResponse)response));
        CoordinatorKey group1 = CoordinatorKey.byGroupId((String)"foo");
        CoordinatorKey group2 = CoordinatorKey.byGroupId((String)"bar");
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.handleResponse(Utils.mkSet((Object[])new CoordinatorKey[]{group1, group2}), (AbstractResponse)response));
    }

    @Test
    public void testSuccessfulOldCoordinatorLookup() {
        CoordinatorKey group = CoordinatorKey.byGroupId((String)"foo");
        FindCoordinatorResponseData responseData = new FindCoordinatorResponseData().setErrorCode(Errors.NONE.code()).setHost("localhost").setPort(9092).setNodeId(1);
        AdminApiLookupStrategy.LookupResult<CoordinatorKey> result = this.runOldLookup(group, responseData);
        Assertions.assertEquals(Collections.singletonMap(group, 1), (Object)result.mappedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
    }

    @Test
    public void testSuccessfulCoordinatorLookup() {
        CoordinatorKey group1 = CoordinatorKey.byGroupId((String)"foo");
        CoordinatorKey group2 = CoordinatorKey.byGroupId((String)"bar");
        FindCoordinatorResponseData responseData = new FindCoordinatorResponseData().setCoordinators(Arrays.asList(new FindCoordinatorResponseData.Coordinator().setKey("foo").setErrorCode(Errors.NONE.code()).setHost("localhost").setPort(9092).setNodeId(1), new FindCoordinatorResponseData.Coordinator().setKey("bar").setErrorCode(Errors.NONE.code()).setHost("localhost").setPort(9092).setNodeId(2)));
        AdminApiLookupStrategy.LookupResult<CoordinatorKey> result = this.runLookup(new HashSet<CoordinatorKey>(Arrays.asList(group1, group2)), responseData);
        HashMap<CoordinatorKey, Integer> expectedResult = new HashMap<CoordinatorKey, Integer>();
        expectedResult.put(group1, 1);
        expectedResult.put(group2, 2);
        Assertions.assertEquals(expectedResult, (Object)result.mappedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
    }

    @Test
    public void testRetriableOldCoordinatorLookup() {
        this.testRetriableOldCoordinatorLookup(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        this.testRetriableOldCoordinatorLookup(Errors.COORDINATOR_NOT_AVAILABLE);
    }

    private void testRetriableOldCoordinatorLookup(Errors error) {
        CoordinatorKey group = CoordinatorKey.byGroupId((String)"foo");
        FindCoordinatorResponseData responseData = new FindCoordinatorResponseData().setErrorCode(error.code());
        AdminApiLookupStrategy.LookupResult<CoordinatorKey> result = this.runOldLookup(group, responseData);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.mappedKeys);
    }

    @Test
    public void testRetriableCoordinatorLookup() {
        this.testRetriableCoordinatorLookup(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        this.testRetriableCoordinatorLookup(Errors.COORDINATOR_NOT_AVAILABLE);
    }

    private void testRetriableCoordinatorLookup(Errors error) {
        CoordinatorKey group1 = CoordinatorKey.byGroupId((String)"foo");
        CoordinatorKey group2 = CoordinatorKey.byGroupId((String)"bar");
        FindCoordinatorResponseData responseData = new FindCoordinatorResponseData().setCoordinators(Arrays.asList(new FindCoordinatorResponseData.Coordinator().setKey("foo").setErrorCode(error.code()), new FindCoordinatorResponseData.Coordinator().setKey("bar").setErrorCode(Errors.NONE.code()).setHost("localhost").setPort(9092).setNodeId(2)));
        AdminApiLookupStrategy.LookupResult<CoordinatorKey> result = this.runLookup(new HashSet<CoordinatorKey>(Arrays.asList(group1, group2)), responseData);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals(Collections.singletonMap(group2, 2), (Object)result.mappedKeys);
    }

    @Test
    public void testFatalErrorOldLookupResponses() {
        CoordinatorKey group = CoordinatorKey.byTransactionalId((String)"foo");
        this.assertFatalOldLookup(group, Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED);
        this.assertFatalOldLookup(group, Errors.UNKNOWN_SERVER_ERROR);
        Throwable throwable = this.assertFatalOldLookup(group, Errors.GROUP_AUTHORIZATION_FAILED);
        Assertions.assertInstanceOf(GroupAuthorizationException.class, (Object)throwable);
        GroupAuthorizationException exception = (GroupAuthorizationException)throwable;
        Assertions.assertEquals((Object)"foo", (Object)exception.groupId());
    }

    public Throwable assertFatalOldLookup(CoordinatorKey key, Errors error) {
        FindCoordinatorResponseData responseData = new FindCoordinatorResponseData().setErrorCode(error.code());
        AdminApiLookupStrategy.LookupResult<CoordinatorKey> result = this.runOldLookup(key, responseData);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.mappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.failedKeys.keySet());
        Throwable throwable = (Throwable)result.failedKeys.get(key);
        Assertions.assertInstanceOf(error.exception().getClass(), (Object)throwable);
        return throwable;
    }

    @Test
    public void testFatalErrorLookupResponses() {
        CoordinatorKey group = CoordinatorKey.byTransactionalId((String)"foo");
        this.assertFatalLookup(group, Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED);
        this.assertFatalLookup(group, Errors.UNKNOWN_SERVER_ERROR);
        Throwable throwable = this.assertFatalLookup(group, Errors.GROUP_AUTHORIZATION_FAILED);
        Assertions.assertInstanceOf(GroupAuthorizationException.class, (Object)throwable);
        GroupAuthorizationException exception = (GroupAuthorizationException)throwable;
        Assertions.assertEquals((Object)"foo", (Object)exception.groupId());
    }

    public Throwable assertFatalLookup(CoordinatorKey key, Errors error) {
        FindCoordinatorResponseData responseData = new FindCoordinatorResponseData().setCoordinators(Collections.singletonList(new FindCoordinatorResponseData.Coordinator().setKey(key.idValue).setErrorCode(error.code())));
        AdminApiLookupStrategy.LookupResult<CoordinatorKey> result = this.runLookup(Collections.singleton(key), responseData);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.mappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.failedKeys.keySet());
        Throwable throwable = (Throwable)result.failedKeys.get(key);
        Assertions.assertInstanceOf(error.exception().getClass(), (Object)throwable);
        return throwable;
    }

    private AdminApiLookupStrategy.LookupResult<CoordinatorKey> runOldLookup(CoordinatorKey key, FindCoordinatorResponseData responseData) {
        CoordinatorStrategy strategy = new CoordinatorStrategy(key.type, new LogContext());
        strategy.disableBatch();
        FindCoordinatorResponse response = new FindCoordinatorResponse(responseData);
        return strategy.handleResponse(Collections.singleton(key), (AbstractResponse)response);
    }

    private AdminApiLookupStrategy.LookupResult<CoordinatorKey> runLookup(Set<CoordinatorKey> keys, FindCoordinatorResponseData responseData) {
        CoordinatorStrategy strategy = new CoordinatorStrategy(keys.iterator().next().type, new LogContext());
        strategy.buildRequest(keys);
        FindCoordinatorResponse response = new FindCoordinatorResponse(responseData);
        return strategy.handleResponse(keys, (AbstractResponse)response);
    }
}

