/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class SampledStatTest {
    private SampledStat stat;
    private Time time;

    SampledStatTest() {
    }

    @BeforeEach
    public void setup() {
        this.stat = new SampleCount();
        this.time = new MockTime();
    }

    @Test
    @DisplayName(value="Sample should be purged if doesn't overlap the window")
    public void testSampleIsPurgedIfDoesntOverlap() {
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.SECONDS).samples(2);
        this.completeSample(config);
        this.time.sleep(2500L);
        double numSamples = this.stat.measure(config, this.time.milliseconds());
        Assertions.assertEquals((double)0.0, (double)numSamples);
    }

    @Test
    @DisplayName(value="Sample should be kept if overlaps the window")
    public void testSampleIsKeptIfOverlaps() {
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.SECONDS).samples(2);
        this.completeSample(config);
        this.time.sleep(1500L);
        double numSamples = this.stat.measure(config, this.time.milliseconds());
        Assertions.assertEquals((double)1.0, (double)numSamples);
    }

    @Test
    @DisplayName(value="Sample should be kept if overlaps the window and is n+1")
    public void testSampleIsKeptIfOverlapsAndExtra() {
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.SECONDS).samples(2);
        this.completeSample(config);
        this.time.sleep(100L);
        this.completeSample(config);
        this.time.sleep(100L);
        this.stat.record(config, 1.0, this.time.milliseconds());
        double numSamples = this.stat.measure(config, this.time.milliseconds());
        Assertions.assertEquals((double)3.0, (double)numSamples);
    }

    private void completeSample(MetricConfig config) {
        this.stat.record(config, 1.0, this.time.milliseconds());
        this.time.sleep(config.timeWindowMs() - 1L);
        this.stat.record(config, 1.0, this.time.milliseconds());
        this.time.sleep(1L);
    }

    static class SampleCount
    extends SampledStat {
        SampleCount() {
            super(0.0);
        }

        protected void update(SampledStat.Sample sample, MetricConfig config, double value, long timeMs) {
            sample.value = 1.0;
        }

        public double combine(List<SampledStat.Sample> samples, MetricConfig config, long now) {
            return samples.stream().mapToDouble(s -> s.value).sum();
        }
    }
}

