/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.registry.otlp.HistogramFlavor;
import io.micrometer.registry.otlp.OtlpConfig;
import io.micrometer.registry.otlp.OtlpHistogramSupport;
import io.micrometer.registry.otlp.OtlpMeterRegistry;
import io.micrometer.registry.otlp.StartTimeAwareMeter;
import io.micrometer.registry.otlp.internal.Base2ExponentialHistogram;
import io.micrometer.registry.otlp.internal.ExponentialHistogramSnapShot;
import java.util.concurrent.TimeUnit;

class OtlpCumulativeDistributionSummary
extends CumulativeDistributionSummary
implements StartTimeAwareMeter,
OtlpHistogramSupport {
    private final HistogramFlavor histogramFlavor;
    private final long startTimeNanos;

    OtlpCumulativeDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, OtlpConfig otlpConfig) {
        super(id, clock, distributionStatisticConfig, scale, OtlpMeterRegistry.getHistogram(clock, distributionStatisticConfig, otlpConfig));
        this.startTimeNanos = TimeUnit.MILLISECONDS.toNanos(clock.wallTime());
        this.histogramFlavor = OtlpMeterRegistry.histogramFlavor(otlpConfig.histogramFlavor(), distributionStatisticConfig);
    }

    @Override
    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    @Override
    @Nullable
    public ExponentialHistogramSnapShot getExponentialHistogramSnapShot() {
        if (this.histogramFlavor == HistogramFlavor.BASE2_EXPONENTIAL_BUCKET_HISTOGRAM) {
            return ((Base2ExponentialHistogram)this.histogram).getLatestExponentialHistogramSnapshot();
        }
        return null;
    }
}

