/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.filter;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractMessageProcessingSelector
implements MessageSelector,
BeanFactoryAware,
ManageableLifecycle {
    private final MessageProcessor<Boolean> messageProcessor;

    public AbstractMessageProcessingSelector(MessageProcessor<Boolean> messageProcessor) {
        Assert.notNull(messageProcessor, (String)"messageProcessor must not be null");
        this.messageProcessor = messageProcessor;
    }

    public void setConversionService(ConversionService conversionService) {
        if (this.messageProcessor instanceof AbstractMessageProcessor) {
            ((AbstractMessageProcessor)this.messageProcessor).setConversionService(conversionService);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        MessageProcessor<Boolean> messageProcessor = this.messageProcessor;
        if (messageProcessor instanceof BeanFactoryAware) {
            BeanFactoryAware beanFactoryAware = (BeanFactoryAware)messageProcessor;
            beanFactoryAware.setBeanFactory(beanFactory);
        }
    }

    protected MessageProcessor<Boolean> getMessageProcessor() {
        return this.messageProcessor;
    }

    @Override
    public final boolean accept(Message<?> message) {
        Boolean result = this.messageProcessor.processMessage(message);
        Assert.notNull((Object)result, (String)"result must not be null");
        Assert.isAssignable(Boolean.class, result.getClass(), (String)"a boolean result is required");
        return result;
    }

    @Override
    public void start() {
        MessageProcessor<Boolean> messageProcessor = this.messageProcessor;
        if (messageProcessor instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)messageProcessor;
            lifecycle.start();
        }
    }

    @Override
    public void stop() {
        MessageProcessor<Boolean> messageProcessor = this.messageProcessor;
        if (messageProcessor instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)messageProcessor;
            lifecycle.stop();
        }
    }

    @Override
    public boolean isRunning() {
        Lifecycle lifecycle;
        MessageProcessor<Boolean> messageProcessor = this.messageProcessor;
        return !(messageProcessor instanceof Lifecycle) || (lifecycle = (Lifecycle)messageProcessor).isRunning();
    }
}

